"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AlertsFlyout", {
  enumerable: true,
  get: function () {
    return _alerts_flyout.AlertsFlyout;
  }
});
exports.useGetAlertFlyoutComponents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _alerts_flyout_header = require("./alerts_flyout_header");
var _alerts_flyout_body = require("./alerts_flyout_body");
var _alerts_flyout_footer = require("./alerts_flyout_footer");
var _parse_alert = require("../pages/alerts/helpers/parse_alert");
var _alerts_flyout = require("./alerts_flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetAlertFlyoutComponents = observabilityRuleTypeRegistry => {
  const body = (0, _react.useCallback)(props => {
    const alert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(props.alert);
    return /*#__PURE__*/_react.default.createElement(_alerts_flyout_body.AlertsFlyoutBody, {
      alert: alert,
      id: props.id
    });
  }, [observabilityRuleTypeRegistry]);
  const header = (0, _react.useCallback)(props => {
    const alert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(props.alert);
    return /*#__PURE__*/_react.default.createElement(_alerts_flyout_header.AlertsFlyoutHeader, {
      alert: alert
    });
  }, [observabilityRuleTypeRegistry]);
  const footer = (0, _react.useCallback)(props => {
    const alert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(props.alert);
    return /*#__PURE__*/_react.default.createElement(_alerts_flyout_footer.AlertsFlyoutFooter, {
      isInApp: false,
      alert: alert
    });
  }, [observabilityRuleTypeRegistry]);
  return (0, _react.useMemo)(() => ({
    body,
    header,
    footer
  }), [body, header, footer]);
};
exports.useGetAlertFlyoutComponents = useGetAlertFlyoutComponents;