"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloStatusBadge = SloStatusBadge;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloStatusBadge({
  slo
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, slo.summary.status === 'NO_DATA' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default"
  }, _i18n.i18n.translate('xpack.observability.slo.sloStatusBadge.noData', {
    defaultMessage: 'No data'
  })), slo.summary.status === 'HEALTHY' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "success"
  }, _i18n.i18n.translate('xpack.observability.slo.sloStatusBadge.healthy', {
    defaultMessage: 'Healthy'
  })), slo.summary.status === 'DEGRADING' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.observability.slo.sloStatusBadge.degrading', {
    defaultMessage: 'Degrading'
  })), slo.summary.status === 'VIOLATED' && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "danger"
  }, _i18n.i18n.translate('xpack.observability.slo.sloStatusBadge.violated', {
    defaultMessage: 'Violated'
  }))), slo.summary.errorBudget.isEstimated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "default"
  }, _i18n.i18n.translate('xpack.observability.slo.sloStatusBadge.forecasted', {
    defaultMessage: 'Forecasted'
  }))));
}