"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityPageTemplate = ObservabilityPageTemplate;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _tour = require("../tour");
var _nav_name_with_badge = require("./nav_name_with_badge");
var _nav_name_with_beta_badge = require("./nav_name_with_beta_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityPageTemplate({
  children,
  currentAppId$,
  getUrlForApp,
  navigateToApp,
  navigationSections$,
  showSolutionNav = true,
  isPageDataLoaded = true,
  getPageTemplateServices,
  bottomBar,
  bottomBarProps,
  pageSectionProps,
  guidedOnboardingApi,
  ...pageTemplateProps
}) {
  var _services$http;
  const sections = (0, _useObservable.default)(navigationSections$, []);
  const currentAppId = (0, _useObservable.default)(currentAppId$, undefined);
  const {
    pathname: currentPath
  } = (0, _reactRouterDom.useLocation)();
  const {
    services
  } = (0, _public.useKibana)();
  const sideNavItems = (0, _react.useMemo)(() => sections.map(({
    label,
    entries,
    isBetaFeature
  }, sectionIndex) => ({
    id: `${sectionIndex}`,
    name: isBetaFeature ? /*#__PURE__*/_react.default.createElement(_nav_name_with_beta_badge.NavNameWithBetaBadge, {
      label: label
    }) : label,
    items: entries.map((entry, entryIndex) => {
      const href = getUrlForApp(entry.app, {
        path: entry.path
      });
      const isSelected = entry.app === currentAppId && (entry.matchPath ? entry.matchPath(currentPath) : (0, _reactRouterDom.matchPath)(currentPath, {
        path: entry.path,
        exact: !!entry.matchFullPath,
        strict: !entry.ignoreTrailingSlash
      }) != null);
      const badgeLocalStorageId = `observability.nav_item_badge_visible_${entry.app}${entry.path}`;
      const navId = entry.label.toLowerCase().split(' ').join('_');
      return {
        id: `${sectionIndex}.${entryIndex}`,
        name: entry.isBetaFeature ? /*#__PURE__*/_react.default.createElement(_nav_name_with_beta_badge.NavNameWithBetaBadge, {
          label: entry.label
        }) : entry.isNewFeature ? /*#__PURE__*/_react.default.createElement(_nav_name_with_badge.NavNameWithBadge, {
          label: entry.label,
          localStorageId: badgeLocalStorageId
        }) : entry.isTechnicalPreview ? /*#__PURE__*/_react.default.createElement(_nav_name_with_beta_badge.NavNameWithBetaBadge, {
          label: entry.label,
          iconType: "beaker",
          isTechnicalPreview: true
        }) : entry.label,
        href,
        isSelected,
        'data-nav-id': navId,
        'data-test-subj': `observability-nav-${entry.app}-${navId}`,
        onClick: event => {
          if (entry.onClick) {
            entry.onClick(event);
          }

          // Hides NEW badge when the item is clicked
          if (entry.isNewFeature) {
            (0, _nav_name_with_badge.hideBadge)(badgeLocalStorageId);
          }
          if (event.button !== 0 || event.defaultPrevented || event.metaKey || event.altKey || event.ctrlKey || event.shiftKey) {
            return;
          }
          event.preventDefault();
          navigateToApp(entry.app, {
            path: entry.path
          });
        }
      };
    })
  })), [currentAppId, currentPath, getUrlForApp, navigateToApp, sections]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplateKibanaProvider, getPageTemplateServices(), /*#__PURE__*/_react.default.createElement(_tour.ObservabilityTour, {
    navigateToApp: navigateToApp,
    prependBasePath: services === null || services === void 0 ? void 0 : (_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.basePath.prepend,
    guidedOnboardingApi: guidedOnboardingApi,
    isPageDataLoaded: isPageDataLoaded
    // The tour is dependent on the solution nav, and should not render if it is not visible
    ,
    showTour: showSolutionNav
  }, ({
    isTourVisible
  }) => {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, (0, _extends2.default)({
      restrictWidth: false
    }, pageTemplateProps, {
      solutionNav: showSolutionNav ? {
        icon: 'logoObservability',
        items: sideNavItems,
        name: sideNavTitle,
        // Only false if tour is active
        canBeCollapsed: isTourVisible === false
      } : undefined
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, (0, _extends2.default)({
      component: "div",
      alignment: pageTemplateProps.isEmptyState ? 'center' : 'top'
    }, pageSectionProps), children)), bottomBar && /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, bottomBarProps, bottomBar));
  }));
}

// for lazy import
// eslint-disable-next-line import/no-default-export
var _default = ObservabilityPageTemplate;
exports.default = _default;
const sideNavTitle = _i18n.i18n.translate('xpack.observability.pageLayout.sideNavTitle', {
  defaultMessage: 'Observability'
});