"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueSuggestions = FieldValueSuggestions;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_values_list = require("../../../hooks/use_values_list");
var _field_value_selection = require("./field_value_selection");
var _field_value_combobox = require("./field_value_combobox");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FieldValueSuggestions({
  fullWidth,
  sourceField,
  label,
  dataViewTitle,
  selectedValue,
  excludedValue,
  filters,
  button,
  time,
  width,
  forceOpen,
  setForceOpen,
  anchorPosition,
  singleSelection,
  compressed,
  asFilterButton,
  usePrependLabel,
  allowAllValuesSelection,
  required,
  allowExclusions = true,
  cardinalityField,
  inspector,
  asCombobox = true,
  keepHistory = true,
  showLogicalConditionSwitch,
  useLogicalAND,
  onChange: onSelectionChange
}) {
  const [query, setQuery] = (0, _react.useState)('');
  const {
    values,
    loading
  } = (0, _use_values_list.useValuesList)({
    dataViewTitle,
    query,
    sourceField,
    filters,
    time,
    inspector,
    cardinalityField,
    keepHistory,
    label
  });
  const SelectionComponent = asCombobox ? _field_value_combobox.FieldValueCombobox : _field_value_selection.FieldValueSelection;
  return /*#__PURE__*/_react.default.createElement(SelectionComponent, {
    fullWidth: fullWidth,
    singleSelection: singleSelection,
    values: values,
    label: label,
    onChange: onSelectionChange,
    query: query,
    setQuery: setQuery,
    loading: loading,
    selectedValue: selectedValue,
    excludedValue: excludedValue,
    button: button,
    forceOpen: forceOpen,
    setForceOpen: setForceOpen,
    anchorPosition: anchorPosition,
    width: width,
    compressed: compressed,
    asFilterButton: asFilterButton,
    usePrependLabel: usePrependLabel,
    allowExclusions: allowExclusions,
    allowAllValuesSelection: singleSelection ? false : allowAllValuesSelection,
    required: required,
    showLogicalConditionSwitch: showLogicalConditionSwitch,
    useLogicalAND: useLogicalAND
  });
}

// eslint-disable-next-line import/no-default-export
var _default = FieldValueSuggestions;
exports.default = _default;