"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueCombobox = FieldValueCombobox;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatOptions = (values, allowAllValuesSelection) => {
  const uniqueValues = Array.from(new Set(allowAllValuesSelection && (values !== null && values !== void 0 ? values : []).length > 0 ? ['ALL_VALUES', ...(values !== null && values !== void 0 ? values : [])] : values));
  return (uniqueValues !== null && uniqueValues !== void 0 ? uniqueValues : []).map(label => ({
    label
  }));
};
function FieldValueCombobox({
  label,
  selectedValue,
  loading,
  values,
  setQuery,
  usePrependLabel = true,
  compressed = true,
  required = true,
  singleSelection = false,
  allowAllValuesSelection,
  onChange: onSelectionChange
}) {
  const [options, setOptions] = (0, _react.useState)(() => {
    var _values$map;
    return formatOptions((0, _lodash.union)((_values$map = values === null || values === void 0 ? void 0 : values.map(({
      label: lb
    }) => lb)) !== null && _values$map !== void 0 ? _values$map : [], selectedValue !== null && selectedValue !== void 0 ? selectedValue : []), allowAllValuesSelection);
  });
  (0, _react.useEffect)(() => {
    var _values$map2;
    setOptions(formatOptions((0, _lodash.union)((_values$map2 = values === null || values === void 0 ? void 0 : values.map(({
      label: lb
    }) => lb)) !== null && _values$map2 !== void 0 ? _values$map2 : [], selectedValue !== null && selectedValue !== void 0 ? selectedValue : []), allowAllValuesSelection));
  }, [allowAllValuesSelection, selectedValue, values]);
  const onChange = selectedValuesN => {
    onSelectionChange(selectedValuesN.map(({
      label: lbl
    }) => lbl));
  };
  const comboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: singleSelection ? {
      asPlainText: true
    } : false,
    compressed: compressed,
    placeholder: _i18n.i18n.translate('xpack.observability.fieldValueSelection.placeholder.search', {
      defaultMessage: 'Search {label}',
      values: {
        label
      }
    }),
    isLoading: loading,
    onSearchChange: searchVal => {
      setQuery(searchVal);
    },
    options: options,
    selectedOptions: options.filter(opt => selectedValue === null || selectedValue === void 0 ? void 0 : selectedValue.includes(opt.label)),
    onChange: onChange,
    isInvalid: required && (0, _lodash.isEmpty)(selectedValue)
  });
  return usePrependLabel ? /*#__PURE__*/_react.default.createElement(ComboWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    prepend: label,
    compressed: true
  }, comboBox)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "center",
    fullWidth: true
  }, comboBox);
}
const ComboWrapper = _styledComponents.default.div`
  &&& {
    .euiFormControlLayout {
      height: auto;
      .euiFormControlLayout__prepend {
        margin: auto;
      }
      .euiComboBoxPill {
        max-width: 250px;
      }
      .euiComboBox__inputWrap {
        border-radius: 0;
      }
    }
  }
`;