"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertSearchBarState = void 0;
exports.useAlertSearchBarStateContainer = useAlertSearchBarStateContainer;
var _Either = require("fp-ts/Either");
var _pipeable = require("fp-ts/pipeable");
var t = _interopRequireWildcard(require("io-ts"));
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/kibana-utils-plugin/public");
var _datemath = require("../../../../utils/datemath");
var _constants = require("../../../../../common/constants");
var _use_timefilter_service = require("../../../../hooks/use_timefilter_service");
var _state_container = require("./state_container");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertSearchBarState = t.partial({
  rangeFrom: _datemath.datemathStringRT,
  rangeTo: _datemath.datemathStringRT,
  kuery: t.string,
  status: t.union([t.literal(_ruleDataUtils.ALERT_STATUS_ACTIVE), t.literal(_ruleDataUtils.ALERT_STATUS_RECOVERED), t.literal(_constants.ALERT_STATUS_ALL)])
});
exports.alertSearchBarState = alertSearchBarState;
function useAlertSearchBarStateContainer(urlStorageKey, {
  replace
} = {}) {
  const stateContainer = (0, _state_container.useContainer)();
  useUrlStateSyncEffect(stateContainer, urlStorageKey, replace);
  const {
    setRangeFrom,
    setRangeTo,
    setKuery,
    setStatus
  } = stateContainer.transitions;
  const {
    rangeFrom,
    rangeTo,
    kuery,
    status
  } = (0, _public.useContainerSelector)(stateContainer, state => state);
  return {
    kuery,
    onKueryChange: setKuery,
    onRangeFromChange: setRangeFrom,
    onRangeToChange: setRangeTo,
    onStatusChange: setStatus,
    rangeFrom,
    rangeTo,
    status
  };
}
function useUrlStateSyncEffect(stateContainer, urlStorageKey, replace = true) {
  const history = (0, _reactRouterDom.useHistory)();
  const timefilterService = (0, _use_timefilter_service.useTimefilterService)();
  (0, _react.useEffect)(() => {
    const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
      history,
      useHash: false,
      useHashQuery: false
    });
    const {
      start,
      stop
    } = setupUrlStateSync(stateContainer, urlStateStorage, urlStorageKey, replace);
    start();
    syncUrlStateWithInitialContainerState(timefilterService, stateContainer, urlStateStorage, urlStorageKey, replace);
    return stop;
  }, [stateContainer, history, timefilterService, urlStorageKey, replace]);
}
function setupUrlStateSync(stateContainer, urlStateStorage, urlStorageKey, replace = true) {
  // This handles filling the state when an incomplete URL set is provided
  const setWithDefaults = changedState => {
    stateContainer.set({
      ..._state_container.defaultState,
      ...changedState
    });
  };
  return (0, _public.syncState)({
    storageKey: urlStorageKey,
    stateContainer: {
      ...stateContainer,
      set: setWithDefaults
    },
    stateStorage: {
      ...urlStateStorage,
      set: (key, state) => urlStateStorage.set(key, state, {
        replace
      })
    }
  });
}
function syncUrlStateWithInitialContainerState(timefilterService, stateContainer, urlStateStorage, urlStorageKey, replace = true) {
  const urlState = alertSearchBarState.decode(urlStateStorage.get(urlStorageKey));
  if ((0, _Either.isRight)(urlState)) {
    const newState = {
      ..._state_container.defaultState,
      ...(0, _pipeable.pipe)(urlState).right
    };
    stateContainer.set(newState);
  } else if (timefilterService.isTimeTouched()) {
    const {
      from,
      to
    } = timefilterService.getTime();
    const newState = {
      ..._state_container.defaultState,
      rangeFrom: from,
      rangeTo: to
    };
    stateContainer.set(newState);
  } else {
    // Reset the state container when no URL state or timefilter range is set to avoid accidentally
    // re-using state set on a previous visit to the page in the same session
    stateContainer.set(_state_container.defaultState);
  }
  urlStateStorage.set(urlStorageKey, stateContainer.get(), {
    replace
  });
}