"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAlertSearchBar = ObservabilityAlertSearchBar;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _components = require("./components");
var _alert_feature_ids = require("../../../config/alert_feature_ids");
var _constants = require("./constants");
var _build_es_query = require("../../../utils/build_es_query");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertStatusQuery = status => {
  return _constants.ALERT_STATUS_QUERY[status] ? [{
    query: _constants.ALERT_STATUS_QUERY[status],
    language: 'kuery'
  }] : [];
};
const toastTitle = _i18n.i18n.translate('xpack.observability.alerts.searchBar.invalidQueryTitle', {
  defaultMessage: 'Invalid query string'
});
function ObservabilityAlertSearchBar({
  appName,
  defaultSearchQueries = _constants.DEFAULT_QUERIES,
  onEsQueryChange,
  onKueryChange,
  onRangeFromChange,
  onRangeToChange,
  onStatusChange,
  kuery,
  rangeFrom,
  rangeTo,
  services: {
    AlertsSearchBar,
    timeFilterService,
    useToasts
  },
  status
}) {
  const toasts = useToasts();
  const onAlertStatusChange = (0, _react.useCallback)(alertStatus => {
    try {
      onEsQueryChange((0, _build_es_query.buildEsQuery)({
        to: rangeTo,
        from: rangeFrom
      }, kuery, [...getAlertStatusQuery(alertStatus), ...defaultSearchQueries]));
    } catch (error) {
      toasts.addError(error, {
        title: toastTitle
      });
      onKueryChange(_constants.DEFAULT_QUERY_STRING);
    }
  }, [onEsQueryChange, rangeTo, rangeFrom, kuery, defaultSearchQueries, toasts, onKueryChange]);
  (0, _react.useEffect)(() => {
    onAlertStatusChange(status);
  }, [onAlertStatusChange, status]);
  const onSearchBarParamsChange = (0, _react.useCallback)(({
    dateRange,
    query
  }) => {
    try {
      // First try to create es query to make sure query is valid, then save it in state
      const esQuery = (0, _build_es_query.buildEsQuery)({
        to: dateRange.to,
        from: dateRange.from
      }, query, [...getAlertStatusQuery(status), ...defaultSearchQueries]);
      if (query) onKueryChange(query);
      timeFilterService.setTime(dateRange);
      onRangeFromChange(dateRange.from);
      onRangeToChange(dateRange.to);
      onEsQueryChange(esQuery);
    } catch (error) {
      toasts.addError(error, {
        title: toastTitle
      });
      onKueryChange(_constants.DEFAULT_QUERY_STRING);
    }
  }, [defaultSearchQueries, timeFilterService, onRangeFromChange, onRangeToChange, onKueryChange, onEsQueryChange, status, toasts]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsSearchBar, {
    appName: appName,
    featureIds: _alert_feature_ids.observabilityAlertFeatureIds,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    query: kuery,
    onQuerySubmit: onSearchBarParamsChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.AlertsStatusFilter, {
    status: status,
    onChange: onStatusChange
  })))));
}

// eslint-disable-next-line import/no-default-export
var _default = ObservabilityAlertSearchBar;
exports.default = _default;