"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXSection = UXSection;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _constants = require("../../../../context/constants");
var _ = require("..");
var _data_handler = require("../../../../data_handler");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_has_data = require("../../../../hooks/use_has_data");
var _use_date_picker_context = require("../../../../hooks/use_date_picker_context");
var _core_web_vitals = _interopRequireDefault(require("../../../shared/core_web_vitals"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function UXSection({
  bucketSize
}) {
  const {
    forceUpdate,
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ExploratoryViewEmbeddable
  } = services.exploratoryView;
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd,
    lastUpdated
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const uxHasDataResponse = hasDataMap.ux;
  const serviceName = uxHasDataResponse === null || uxHasDataResponse === void 0 ? void 0 : uxHasDataResponse.serviceName;
  const seriesList = [{
    name: PAGE_LOAD_DISTRIBUTION_TITLE,
    time: {
      from: relativeStart,
      to: relativeEnd
    },
    reportDefinitions: {
      [_common.SERVICE_NAME]: ['ALL_VALUES']
    },
    breakdown: _common.SERVICE_NAME,
    dataType: _constants.UX_APP,
    selectedMetricField: _common.TRANSACTION_DURATION,
    showPercentileAnnotations: false
  }];
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(() => {
    if (serviceName && bucketSize && absoluteStart && absoluteEnd) {
      var _getDataHandler;
      return (_getDataHandler = (0, _data_handler.getDataHandler)('ux')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.fetchData({
        absoluteTime: {
          start: absoluteStart,
          end: absoluteEnd
        },
        relativeTime: {
          start: relativeStart,
          end: relativeEnd
        },
        serviceName,
        ...bucketSize
      });
    }
  },
  // `forceUpdate` and `lastUpdated` should trigger a reload
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [bucketSize, relativeStart, relativeEnd, absoluteStart, absoluteEnd, forceUpdate, serviceName, lastUpdated]);
  if (!(uxHasDataResponse !== null && uxHasDataResponse !== void 0 && uxHasDataResponse.hasData)) {
    return null;
  }
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const {
    appLink,
    coreWebVitals
  } = data || {};
  return /*#__PURE__*/_react.default.createElement(_.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.ux.title', {
      defaultMessage: 'User Experience'
    }),
    appLink: {
      href: appLink,
      label: _i18n.i18n.translate('xpack.observability.overview.ux.appLink', {
        defaultMessage: 'Show dashboard'
      })
    },
    hasError: status === _use_fetcher.FETCH_STATUS.FAILURE
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: 320
    }
  }, /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    attributes: seriesList,
    reportType: "data-distribution",
    title: PAGE_LOAD_DISTRIBUTION_TITLE,
    withActions: false
  })), /*#__PURE__*/_react.default.createElement(_core_web_vitals.default, {
    data: coreWebVitals,
    loading: isLoading,
    displayServiceName: true,
    serviceName: serviceName
  }));
}
const PAGE_LOAD_DISTRIBUTION_TITLE = _i18n.i18n.translate('xpack.observability.overview.ux.pageLoadDistribution.title', {
  defaultMessage: 'Page load distribution'
});