"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsSection = MetricsSection;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _ = require("..");
var _data_handler = require("../../../../data_handler");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_has_data = require("../../../../hooks/use_has_data");
var _use_date_picker_context = require("../../../../hooks/use_date_picker_context");
var _host_link = require("./host_link");
var _format_duration = require("./lib/format_duration");
var _metric_with_sparkline = require("./metric_with_sparkline");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const COLOR_ORANGE = 7;
const COLOR_BLUE = 1;
const COLOR_GREEN = 0;
const COLOR_PURPLE = 3;
const percentFormatter = value => value === null ? '' : (0, _numeral.default)(value).format('0[.0]%');
const numberFormatter = value => value === null ? '' : (0, _numeral.default)(value).format('0[.0]');
const bytesPerSecondFormatter = value => value === null ? '' : (0, _numeral.default)(value).format('0b') + '/s';
function MetricsSection({
  bucketSize
}) {
  var _hasDataMap$infra_met, _viewData$series;
  const {
    forceUpdate,
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd,
    lastUpdated
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const [sortField, setSortField] = (0, _react.useState)('uptime');
  const [sortedData, setSortedData] = (0, _react.useState)(null);
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(() => {
    if (bucketSize && absoluteStart && absoluteEnd) {
      var _getDataHandler;
      return (_getDataHandler = (0, _data_handler.getDataHandler)('infra_metrics')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.fetchData({
        absoluteTime: {
          start: absoluteStart,
          end: absoluteEnd
        },
        relativeTime: {
          start: relativeStart,
          end: relativeEnd
        },
        ...bucketSize
      });
    }
    // `forceUpdate` and `lastUpdated` should trigger a reload
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [bucketSize, relativeStart, relativeEnd, absoluteStart, absoluteEnd, forceUpdate, lastUpdated]);
  const handleTableChange = (0, _react.useCallback)(({
    sort
  }) => {
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortField(field);
      setSortDirection(direction);
      if (data) {
        (async () => {
          const response = await data.sort(field, direction);
          setSortedData(response || null);
        })();
      }
    }
  }, [data, setSortField, setSortDirection]);
  if (!((_hasDataMap$infra_met = hasDataMap.infra_metrics) !== null && _hasDataMap$infra_met !== void 0 && _hasDataMap$infra_met.hasData)) {
    return null;
  }
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const isInitialLoad = isLoading && !data;
  const columns = [{
    field: 'uptime',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.uptime', {
      defaultMessage: 'Uptime'
    }),
    sortable: true,
    width: '80px',
    render: value => value == null ? 'N/A' : (0, _format_duration.formatDuration)(value / 1000)
  }, {
    field: 'name',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.hostname', {
      defaultMessage: 'Hostname'
    }),
    sortable: true,
    truncateText: true,
    isExpander: true,
    textOnly: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_host_link.HostLink, {
      id: record.id,
      name: value,
      timerange: {
        from: absoluteStart,
        to: absoluteEnd
      }
    })
  }, {
    field: 'cpu',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.cpu', {
      defaultMessage: 'CPU %'
    }),
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "cpu",
      value: value,
      formatter: percentFormatter,
      timeseries: record.timeseries,
      color: COLOR_ORANGE
    })
  }, {
    field: 'load',
    name: _i18n.i18n.translate('xpack.observability.overview.metrics.colunms.load15', {
      defaultMessage: 'Load 15'
    }),
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "load",
      value: value,
      formatter: numberFormatter,
      timeseries: record.timeseries,
      color: COLOR_BLUE
    })
  }, {
    field: 'rx',
    name: 'RX',
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "rx",
      value: value,
      formatter: bytesPerSecondFormatter,
      timeseries: record.timeseries,
      color: COLOR_GREEN
    })
  }, {
    field: 'tx',
    name: 'TX',
    sortable: true,
    render: (value, record) => /*#__PURE__*/_react.default.createElement(_metric_with_sparkline.MetricWithSparkline, {
      id: "tx",
      value: value,
      formatter: bytesPerSecondFormatter,
      timeseries: record.timeseries,
      color: COLOR_PURPLE
    })
  }];
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const viewData = sortedData || data;
  const {
    appLink
  } = data || {};
  return /*#__PURE__*/_react.default.createElement(_.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.metrics.title', {
      defaultMessage: 'Hosts'
    }),
    appLink: {
      href: appLink,
      label: _i18n.i18n.translate('xpack.observability.overview.metrics.appLink', {
        defaultMessage: 'Show inventory'
      })
    },
    hasError: status === _use_fetcher.FETCH_STATUS.FAILURE
  }, isInitialLoad ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "loading",
    style: {
      height: 240,
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    onChange: handleTableChange,
    sorting: sorting,
    items: (_viewData$series = viewData === null || viewData === void 0 ? void 0 : viewData.series) !== null && _viewData$series !== void 0 ? _viewData$series : [],
    columns: columns,
    loading: isLoading
  }));
}