"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SectionContainer = SectionContainer;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _error_panel = require("./error_panel");
var _experimental_badge = require("../../shared/experimental_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SectionContainer({
  title,
  appLink,
  children,
  hasError,
  initialIsOpen = true,
  showExperimentalBadge = false
}) {
  const {
    http
  } = (0, _public.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: initialIsOpen,
    id: title,
    buttonContentClassName: "accordion-button",
    "data-test-subj": `accordion-${title}`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, title))), showExperimentalBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_experimental_badge.ExperimentalBadge, null)))),
    extraAction: (appLink === null || appLink === void 0 ? void 0 : appLink.href) && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11ySectionContainerButton",
      iconType: 'sortRight',
      size: "xs",
      color: "text",
      href: http.basePath.prepend(appLink.href)
    }, appLink.label)
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, hasError ? /*#__PURE__*/_react.default.createElement(_error_panel.ErrorPanel, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)))));
}