"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APMSection = APMSection;
var _charts = require("@elastic/charts");
var _formatters = require("@elastic/charts/dist/utils/data/formatters");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = require("styled-components");
var _use_date_picker_context = require("../../../../hooks/use_date_picker_context");
var _ = require("..");
var _data_handler = require("../../../../data_handler");
var _use_chart_theme = require("../../../../hooks/use_chart_theme");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_has_data = require("../../../../hooks/use_has_data");
var _chart_container = require("../../chart_container");
var _styled_stat = require("../../styled_stat");
var _helper = require("../helper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatTpm(value) {
  return (0, _numeral.default)(value).format('0.00a');
}
function formatTpmStat(value) {
  if (!value || value === 0) {
    return '0';
  }
  if (value <= 0.1) {
    return '< 0.1';
  }
  if (value > 1000) {
    return (0, _numeral.default)(value).format('0.00a');
  }
  return (0, _numeral.default)(value).format('0,0.0');
}
function APMSection({
  bucketSize
}) {
  var _hasDataMap$apm;
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  const chartTheme = (0, _use_chart_theme.useChartTheme)();
  const history = (0, _reactRouterDom.useHistory)();
  const {
    forceUpdate,
    hasDataMap
  } = (0, _use_has_data.useHasData)();
  const {
    relativeStart,
    relativeEnd,
    absoluteStart,
    absoluteEnd,
    lastUpdated
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(() => {
    if (bucketSize && absoluteStart && absoluteEnd) {
      var _getDataHandler;
      return (_getDataHandler = (0, _data_handler.getDataHandler)('apm')) === null || _getDataHandler === void 0 ? void 0 : _getDataHandler.fetchData({
        absoluteTime: {
          start: absoluteStart,
          end: absoluteEnd
        },
        relativeTime: {
          start: relativeStart,
          end: relativeEnd
        },
        ...bucketSize
      });
    }
  },
  // `forceUpdate` and `lastUpdated` should trigger a reload
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [bucketSize, relativeStart, relativeEnd, absoluteStart, absoluteEnd, forceUpdate, lastUpdated]);
  if (!((_hasDataMap$apm = hasDataMap.apm) !== null && _hasDataMap$apm !== void 0 && _hasDataMap$apm.hasData)) {
    return null;
  }
  const {
    appLink,
    stats,
    series
  } = data || {};
  const min = _moment.default.utc(absoluteStart).valueOf();
  const max = _moment.default.utc(absoluteEnd).valueOf();
  const formatter = bucketSize !== null && bucketSize !== void 0 && bucketSize.dateFormat ? (0, _formatters.timeFormatter)(bucketSize === null || bucketSize === void 0 ? void 0 : bucketSize.dateFormat) : (0, _charts.niceTimeFormatter)([min, max]);
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const transactionsColor = theme.eui.euiColorVis1;
  return /*#__PURE__*/_react.default.createElement(_.SectionContainer, {
    title: _i18n.i18n.translate('xpack.observability.overview.apm.title', {
      defaultMessage: 'Services'
    }),
    appLink: {
      href: appLink,
      label: _i18n.i18n.translate('xpack.observability.overview.apm.appLink', {
        defaultMessage: 'Show service inventory'
      })
    },
    hasError: status === _use_fetcher.FETCH_STATUS.FAILURE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    title: (0, _numeral.default)(stats === null || stats === void 0 ? void 0 : stats.services.value).format('0a'),
    description: _i18n.i18n.translate('xpack.observability.overview.apm.services', {
      defaultMessage: 'Services'
    }),
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_styled_stat.StyledStat, {
    title: `${formatTpmStat(stats === null || stats === void 0 ? void 0 : stats.transactions.value)} tpm`,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.observability.overview.apm.throughputTip', {
        defaultMessage: 'Values are calculated for transactions with type "Request" or "page-load". If neither are available, values reflect the top transaction type.'
      })
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.overview.apm.throughput', {
      defaultMessage: 'Throughput'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "s",
      color: "subdued",
      type: "questionInCircle",
      className: "eui-alignCenter"
    }))),
    isLoading: isLoading,
    color: transactionsColor
  }))), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    isInitialLoad: isLoading && !data
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    onBrushEnd: event => (0, _helper.onBrushEnd)({
      x: event.x,
      history
    }),
    theme: chartTheme,
    showLegend: false,
    xDomain: {
      min,
      max
    }
  }), (series === null || series === void 0 ? void 0 : series.transactions.coordinates) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: "transactions",
    name: "Transactions",
    data: series === null || series === void 0 ? void 0 : series.transactions.coordinates,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: 'x',
    yAccessors: ['y'],
    color: transactionsColor
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    position: _charts.Position.Left,
    gridLine: {
      visible: true
    },
    tickFormat: value => `${formatTpm(value)} tpm`
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    position: _charts.Position.Bottom,
    tickFormat: formatter
  }))));
}