"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CompletedStatusBox = CompletedStatusBox;
exports.EmptyStatusBox = EmptyStatusBox;
exports.ObservabilityStatusBox = ObservabilityStatusBox;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_track_metric = require("../../../hooks/use_track_metric");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityStatusBox(props) {
  if (props.hasData) {
    return /*#__PURE__*/_react.default.createElement(CompletedStatusBox, props);
  } else {
    return /*#__PURE__*/_react.default.createElement(EmptyStatusBox, props);
  }
}
function CompletedStatusBox({
  id,
  title,
  modules,
  addLink,
  addTitle,
  goToAppTitle,
  goToAppLink
}) {
  const {
    application
  } = (0, _kibana_react.useKibana)().services;
  const trackMetric = (0, _use_track_metric.useUiTracker)({
    app: 'observability-overview'
  });
  const goToAddLink = (0, _react.useCallback)(() => {
    trackMetric({
      metric: `guided_setup_add_integrations_${id}`
    });
    application.navigateToUrl(addLink);
  }, [addLink, application, trackMetric, id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "plain",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "checkInCircleFilled",
    color: "success",
    className: "eui-displayInline eui-alignMiddle",
    style: {
      marginRight: 8
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    className: "eui-displayInline eui-alignMiddle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yCompletedStatusBoxButton",
    size: "s",
    iconType: "plusInCircle",
    flush: "right",
    onClick: goToAddLink
  }, addTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.dataAvailable",
    defaultMessage: "Data is available."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "s",
    style: {
      marginTop: 8
    },
    role: "list"
  }, modules.map(module => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    role: "listitem",
    key: module.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: module.hasData ? 'success' : 'hollow',
    iconType: "check",
    iconSide: "left"
  }, module.name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yCompletedStatusBoxButton",
    color: "primary",
    href: goToAppLink
  }, goToAppTitle))));
}
function EmptyStatusBox({
  id,
  title,
  description,
  learnMoreLink,
  addTitle,
  addLink
}) {
  const {
    application
  } = (0, _kibana_react.useKibana)().services;
  const trackMetric = (0, _use_track_metric.useUiTracker)({
    app: 'observability-overview'
  });
  const goToAddLink = (0, _react.useCallback)(() => {
    trackMetric({
      metric: `guided_setup_add_data_${id}`
    });
    application.navigateToUrl(addLink);
  }, [id, trackMetric, application, addLink]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "warning",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircleFilled",
    color: "warning",
    className: "eui-displayInline eui-alignMiddle",
    style: {
      marginRight: 8
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    className: "eui-displayInline eui-alignMiddle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, title))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yEmptyStatusBoxButton",
    color: "primary",
    onClick: goToAddLink,
    fill: true
  }, addTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11yEmptyStatusBoxLearnMoreLink",
    color: "primary",
    href: learnMoreLink,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.learnMoreButton",
    defaultMessage: "Learn more"
  })))));
}