"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContent = void 0;
var _i18n = require("@kbn/i18n");
var _paths = require("../../../config/paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getContent = (http, docLinks) => {
  return [{
    id: 'infra_logs',
    title: _i18n.i18n.translate('xpack.observability.statusVisualization.logs.title', {
      defaultMessage: 'Logs'
    }),
    description: _i18n.i18n.translate('xpack.observability.statusVisualization.logs.description', {
      defaultMessage: 'Fast, easy, and scalable centralized log monitoring with out-of-the-box support for common data sources.'
    }),
    addTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.logs.link', {
      defaultMessage: 'Add integrations'
    }),
    addLink: http.basePath.prepend('/app/integrations/browse?q=logs'),
    learnMoreLink: docLinks.links.observability.monitorLogs,
    goToAppTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.logs.goToAppTitle', {
      defaultMessage: 'Show log stream'
    }),
    goToAppLink: http.basePath.prepend('/app/logs/stream'),
    weight: 1
  }, {
    id: 'apm',
    title: _i18n.i18n.translate('xpack.observability.statusVisualization.apm.title', {
      defaultMessage: 'APM'
    }),
    description: _i18n.i18n.translate('xpack.observability.statusVisualization.apm.description', {
      defaultMessage: 'Get deeper visibility into your applications with extensive support for popular languages, OpenTelemetry, and distributed tracing.'
    }),
    addTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.apm.link', {
      defaultMessage: 'Add data'
    }),
    addLink: http.basePath.prepend('/app/home#/tutorial/apm'),
    learnMoreLink: docLinks.links.apm.overview,
    goToAppTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.apm.goToAppTitle', {
      defaultMessage: 'Show services inventory'
    }),
    goToAppLink: http.basePath.prepend('/app/apm/services'),
    weight: 3
  }, {
    id: 'infra_metrics',
    title: _i18n.i18n.translate('xpack.observability.statusVisualization.metrics.title', {
      defaultMessage: 'Infrastructure'
    }),
    description: _i18n.i18n.translate('xpack.observability.statusVisualization.metrics.description', {
      defaultMessage: 'Stream, visualize, and analyze your infrastructure metrics.'
    }),
    addTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.metrics.link', {
      defaultMessage: 'Add integrations'
    }),
    addLink: http.basePath.prepend('/app/integrations/browse?q=metrics'),
    learnMoreLink: docLinks.links.observability.analyzeMetrics,
    goToAppTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.metrics.goToAppTitle', {
      defaultMessage: 'Show inventory'
    }),
    goToAppLink: http.basePath.prepend('/app/metrics/inventory'),
    weight: 2
  }, {
    id: 'uptime',
    title: _i18n.i18n.translate('xpack.observability.statusVisualization.uptime.title', {
      defaultMessage: 'Uptime'
    }),
    description: _i18n.i18n.translate('xpack.observability.statusVisualization.uptime.description', {
      defaultMessage: 'Proactively monitor the availability and functionality of user journeys.'
    }),
    addTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.uptime.link', {
      defaultMessage: 'Add monitors'
    }),
    addLink: http.basePath.prepend('/app/home#/tutorial/uptimeMonitors'),
    learnMoreLink: docLinks.links.observability.monitorUptimeSynthetics,
    goToAppTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.uptime.goToAppTitle', {
      defaultMessage: 'Show monitors '
    }),
    goToAppLink: http.basePath.prepend('/app/uptime'),
    weight: 4
  }, {
    id: 'ux',
    title: _i18n.i18n.translate('xpack.observability.statusVisualization.ux.title', {
      defaultMessage: 'User Experience'
    }),
    description: _i18n.i18n.translate('xpack.observability.statusVisualization.ux.description', {
      defaultMessage: 'Collect, measure, and analyze performance data that reflects real-world user experiences.'
    }),
    addTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.ux.link', {
      defaultMessage: 'Add data'
    }),
    addLink: http.basePath.prepend('/app/home#/tutorial/apm'),
    learnMoreLink: docLinks.links.observability.userExperience,
    goToAppTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.ux.goToAppTitle', {
      defaultMessage: 'Show dashboard'
    }),
    goToAppLink: http.basePath.prepend('/app/ux'),
    weight: 5
  }, {
    id: 'alert',
    title: _i18n.i18n.translate('xpack.observability.statusVisualization.alert.title', {
      defaultMessage: 'Alerting'
    }),
    description: _i18n.i18n.translate('xpack.observability.statusVisualization.alert.description', {
      defaultMessage: 'Detect complex conditions in Observability and trigger actions when those conditions are met.'
    }),
    addTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.alert.link', {
      defaultMessage: 'Create rules'
    }),
    addLink: http.basePath.prepend(_paths.paths.observability.rules),
    learnMoreLink: docLinks.links.observability.createAlerts,
    goToAppTitle: _i18n.i18n.translate('xpack.observability.statusVisualization.alert.goToAppTitle', {
      defaultMessage: 'Show alerts'
    }),
    goToAppLink: http.basePath.prepend('/app/observability/alerts'),
    weight: 6
  }];
};
exports.getContent = getContent;