"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRateRuleEditor = BurnRateRuleEditor;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _duration = require("../../../utils/slo/duration");
var _use_fetch_slo_details = require("../../../hooks/slo/use_fetch_slo_details");
var _slo_selector = require("./slo_selector");
var _burn_rate = require("./burn_rate");
var _long_window_duration = require("./long_window_duration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BurnRateRuleEditor(props) {
  var _ruleParams$longWindo, _ruleParams$longWindo2, _ref, _ruleParams$longWindo3, _ruleParams$shortWind, _ruleParams$shortWind2, _ref2, _ruleParams$shortWind3, _ruleParams$burnRateT, _ruleParams$maxBurnRa;
  const {
    setRuleParams,
    ruleParams,
    errors
  } = props;
  const {
    isLoading: loadingInitialSlo,
    slo: initialSlo
  } = (0, _use_fetch_slo_details.useFetchSloDetails)({
    sloId: ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.sloId
  });
  const [selectedSlo, setSelectedSlo] = (0, _react.useState)(undefined);
  const [longWindowDuration, setLongWindowDuration] = (0, _react.useState)({
    value: (_ruleParams$longWindo = ruleParams === null || ruleParams === void 0 ? void 0 : (_ruleParams$longWindo2 = ruleParams.longWindow) === null || _ruleParams$longWindo2 === void 0 ? void 0 : _ruleParams$longWindo2.value) !== null && _ruleParams$longWindo !== void 0 ? _ruleParams$longWindo : 1,
    unit: (_ref = ruleParams === null || ruleParams === void 0 ? void 0 : (_ruleParams$longWindo3 = ruleParams.longWindow) === null || _ruleParams$longWindo3 === void 0 ? void 0 : _ruleParams$longWindo3.unit) !== null && _ref !== void 0 ? _ref : 'h'
  });
  const [shortWindowDuration, setShortWindowDuration] = (0, _react.useState)({
    value: (_ruleParams$shortWind = ruleParams === null || ruleParams === void 0 ? void 0 : (_ruleParams$shortWind2 = ruleParams.shortWindow) === null || _ruleParams$shortWind2 === void 0 ? void 0 : _ruleParams$shortWind2.value) !== null && _ruleParams$shortWind !== void 0 ? _ruleParams$shortWind : 5,
    unit: (_ref2 = ruleParams === null || ruleParams === void 0 ? void 0 : (_ruleParams$shortWind3 = ruleParams.shortWindow) === null || _ruleParams$shortWind3 === void 0 ? void 0 : _ruleParams$shortWind3.unit) !== null && _ref2 !== void 0 ? _ref2 : 'm'
  });
  const [burnRate, setBurnRate] = (0, _react.useState)((_ruleParams$burnRateT = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.burnRateThreshold) !== null && _ruleParams$burnRateT !== void 0 ? _ruleParams$burnRateT : 1);
  const [maxBurnRate, setMaxBurnRate] = (0, _react.useState)((_ruleParams$maxBurnRa = ruleParams === null || ruleParams === void 0 ? void 0 : ruleParams.maxBurnRateThreshold) !== null && _ruleParams$maxBurnRa !== void 0 ? _ruleParams$maxBurnRa : 1);
  (0, _react.useEffect)(() => {
    const hasInitialSlo = !loadingInitialSlo && initialSlo !== undefined;
    setSelectedSlo(hasInitialSlo ? initialSlo : undefined);
  }, [loadingInitialSlo, initialSlo, setRuleParams]);
  const onLongWindowDurationChange = duration => {
    setLongWindowDuration(duration);
    const longWindowDurationInMinutes = (0, _duration.toMinutes)(duration);
    const shortWindowDurationValue = Math.floor(longWindowDurationInMinutes / 12);
    setShortWindowDuration({
      value: shortWindowDurationValue,
      unit: 'm'
    });
  };
  const onBurnRateChange = value => {
    setBurnRate(value);
    setRuleParams('burnRateThreshold', value);
  };
  const onSelectedSlo = slo => {
    setSelectedSlo(slo);
    setRuleParams('sloId', slo === null || slo === void 0 ? void 0 : slo.id);
  };
  (0, _react.useEffect)(() => {
    if (selectedSlo) {
      const sloDurationInMinutes = (0, _duration.toMinutes)((0, _duration.toDuration)(selectedSlo.timeWindow.duration));
      const longWindowDurationInMinutes = (0, _duration.toMinutes)(longWindowDuration);
      const maxBurnRateThreshold = Math.floor(sloDurationInMinutes / longWindowDurationInMinutes);
      setMaxBurnRate(maxBurnRateThreshold);
    }
  }, [longWindowDuration, selectedSlo]);
  (0, _react.useEffect)(() => {
    setRuleParams('longWindow', longWindowDuration);
    setRuleParams('shortWindow', shortWindowDuration);
  }, [shortWindowDuration, longWindowDuration, setRuleParams]);
  (0, _react.useEffect)(() => {
    setRuleParams('burnRateThreshold', burnRate);
    setRuleParams('maxBurnRateThreshold', maxBurnRate);
  }, [burnRate, maxBurnRate, setRuleParams]);
  const computeErrorBudgetExhaustionInHours = () => {
    if (selectedSlo && (longWindowDuration === null || longWindowDuration === void 0 ? void 0 : longWindowDuration.value) > 0 && burnRate >= 1) {
      return (0, _numeral.default)(longWindowDuration.value / (burnRate * (0, _duration.toMinutes)(longWindowDuration) / (0, _duration.toMinutes)((0, _duration.toDuration)(selectedSlo.timeWindow.duration)))).format('0a');
    }
    return 'N/A';
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_selector.SloSelector, {
    initialSlo: selectedSlo,
    onSelected: onSelectedSlo,
    errors: errors.sloId
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_long_window_duration.LongWindowDuration, {
    initialDuration: longWindowDuration,
    shortWindowDuration: shortWindowDuration,
    onChange: onLongWindowDurationChange,
    errors: errors.longWindow
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_burn_rate.BurnRate, {
    initialBurnRate: burnRate,
    maxBurnRate: maxBurnRate,
    onChange: onBurnRateChange,
    errors: errors.burnRateThreshold,
    helpText: getErrorBudgetExhaustionText(computeErrorBudgetExhaustionInHours())
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}
const getErrorBudgetExhaustionText = formattedHours => _i18n.i18n.translate('xpack.observability.slo.rules.errorBudgetExhaustion.text', {
  defaultMessage: '{formatedHours} hours until error budget exhaustion.',
  values: {
    formatedHours: formattedHours
  }
});