"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyoutBody = AlertsFlyoutBody;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana_react = require("../utils/kibana_react");
var _formatters = require("../../common/utils/formatters");
var _paths = require("../config/paths");
var _translations = require("../config/translations");
var _format_alert_evaluation_value = require("../utils/format_alert_evaluation_value");
var _constants = require("../pages/rule_details/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyoutBody({
  alert,
  id: pageId
}) {
  var _get, _alert$fields$ALERT_R;
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const dateFormat = (0, _public.useUiSetting)('dateFormat');
  const ruleId = (_get = (0, _lodash.get)(alert.fields, _ruleDataUtils.ALERT_RULE_UUID)) !== null && _get !== void 0 ? _get : null;
  const linkToRule = pageId !== _constants.RULE_DETAILS_PAGE_ID && ruleId && prepend ? prepend(_paths.paths.observability.ruleDetails(ruleId)) : null;
  const overviewListItems = [{
    title: _translations.translations.alertsFlyout.statusLabel,
    description: /*#__PURE__*/_react.default.createElement(_alertsUiShared.AlertLifecycleStatusBadge, {
      alertStatus: alert.active ? _ruleDataUtils.ALERT_STATUS_ACTIVE : _ruleDataUtils.ALERT_STATUS_RECOVERED,
      flapping: alert.fields[_ruleDataUtils.ALERT_FLAPPING]
    })
  }, {
    title: _translations.translations.alertsFlyout.startedAtLabel,
    description: /*#__PURE__*/_react.default.createElement("span", {
      title: alert.start.toString()
    }, (0, _momentTimezone.default)(alert.start).format(dateFormat))
  }, {
    title: _translations.translations.alertsFlyout.lastUpdatedLabel,
    description: /*#__PURE__*/_react.default.createElement("span", {
      title: alert.lastUpdated.toString()
    }, (0, _momentTimezone.default)(alert.lastUpdated).format(dateFormat))
  }, {
    title: _translations.translations.alertsFlyout.durationLabel,
    description: (0, _formatters.asDuration)(alert.fields[_ruleDataUtils.ALERT_DURATION], {
      extended: true
    })
  }, {
    title: _translations.translations.alertsFlyout.expectedValueLabel,
    description: (0, _format_alert_evaluation_value.formatAlertEvaluationValue)(alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID], alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD])
  }, {
    title: _translations.translations.alertsFlyout.actualValueLabel,
    description: (0, _format_alert_evaluation_value.formatAlertEvaluationValue)(alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID], alert.fields[_ruleDataUtils.ALERT_EVALUATION_VALUE])
  }, {
    title: _translations.translations.alertsFlyout.ruleTypeLabel,
    description: (_alert$fields$ALERT_R = alert.fields[_ruleDataUtils.ALERT_RULE_CATEGORY]) !== null && _alert$fields$ALERT_R !== void 0 ? _alert$fields$ALERT_R : '-'
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations.translations.alertsFlyout.reasonTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, alert.reason), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !!linkToRule && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: linkToRule,
    "data-test-subj": "viewRuleDetailsFlyout"
  }, _translations.translations.alertsFlyout.viewRulesDetailsLinkText), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "full"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations.translations.alertsFlyout.documentSummaryTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    type: "responsiveColumn",
    listItems: overviewListItems,
    titleProps: {
      'data-test-subj': 'alertsFlyoutDescriptionListTitle'
    },
    descriptionProps: {
      'data-test-subj': 'alertsFlyoutDescriptionListDescription'
    }
  }));
}