"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyout = AlertsFlyout;
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _alerts_flyout_header = require("./alerts_flyout_header");
var _alerts_flyout_body = require("./alerts_flyout_body");
var _alerts_flyout_footer = require("./alerts_flyout_footer");
var _parse_alert = require("../pages/alerts/helpers/parse_alert");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyout({
  alert,
  alerts,
  isInApp = false,
  observabilityRuleTypeRegistry,
  onClose,
  selectedAlertId
}) {
  const decoratedAlerts = (0, _react.useMemo)(() => {
    const parseObservabilityAlert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry);
    return (alerts !== null && alerts !== void 0 ? alerts : []).map(parseObservabilityAlert);
  }, [alerts, observabilityRuleTypeRegistry]);
  let alertData = alert;
  if (!alertData) {
    alertData = decoratedAlerts === null || decoratedAlerts === void 0 ? void 0 : decoratedAlerts.find(a => a.fields[_ruleDataUtils.ALERT_UUID] === selectedAlertId);
  }
  if (!alertData) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    className: "oblt__flyout",
    onClose: onClose,
    size: "s",
    "data-test-subj": "alertsFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_alerts_flyout_header.AlertsFlyoutHeader, {
    alert: alertData
  })), /*#__PURE__*/_react.default.createElement(_alerts_flyout_body.AlertsFlyoutBody, {
    alert: alertData
  }), /*#__PURE__*/_react.default.createElement(_alerts_flyout_footer.AlertsFlyoutFooter, {
    alert: alertData,
    isInApp: isInApp
  }));
}

// eslint-disable-next-line import/no-default-export
var _default = AlertsFlyout;
exports.default = _default;