"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingPlugin = void 0;
var _public = require("@kbn/core/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class ObservabilityOnboardingPlugin {
  constructor(ctx) {
    this.ctx = ctx;
  }
  setup(core, plugins) {
    const {
      ui: {
        enabled: isObservabilityOnboardingUiEnabled
      }
    } = this.ctx.config.get();
    const pluginSetupDeps = plugins;

    // set xpack.observability_onboarding.ui.enabled: true
    // and go to /app/observabilityOnboarding
    if (isObservabilityOnboardingUiEnabled) {
      core.application.register({
        navLinkStatus: _public.AppNavLinkStatus.hidden,
        id: 'observabilityOnboarding',
        title: 'Observability Onboarding',
        order: 8500,
        euiIconType: 'logoObservability',
        category: _public.DEFAULT_APP_CATEGORIES.observability,
        keywords: [],
        async mount(appMountParameters) {
          // Load application bundle and Get start service
          const [{
            renderApp
          }, [coreStart, corePlugins]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application/app'))), core.getStartServices()]);
          const {
            createCallApi
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/create_call_api')));
          createCallApi(core);
          return renderApp({
            core: coreStart,
            deps: pluginSetupDeps,
            appMountParameters,
            corePlugins: corePlugins
          });
        }
      });
    }
  }
  start(core, plugins) {}
}
exports.ObservabilityOnboardingPlugin = ObservabilityOnboardingPlugin;