"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWizardContext = createWizardContext;
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createWizardContext({
  initialState,
  initialStep,
  steps
}) {
  const context = /*#__PURE__*/(0, _react.createContext)({
    CurrentStep: () => null,
    goToStep: () => {},
    goBack: () => {},
    getState: () => initialState,
    setState: () => {},
    getPath: () => [],
    getUsage: () => ({
      timeSinceStart: 0,
      navEvents: []
    })
  });
  function Provider({
    children,
    onChangeStep,
    transitionDuration
  }) {
    const [step, setStep] = (0, _react.useState)(initialStep);
    const pathRef = (0, _react.useRef)([initialStep]);
    const usageRef = (0, _react.useRef)({
      timeSinceStart: 0,
      navEvents: [{
        type: 'initial',
        step,
        timestamp: Date.now(),
        duration: 0
      }]
    });
    const [state, setState] = (0, _react.useState)(initialState);
    return /*#__PURE__*/_react.default.createElement(context.Provider, {
      value: {
        CurrentStep: steps[step],
        goToStep(stepKey) {
          if (stepKey === step) {
            return;
          }
          pathRef.current.push(stepKey);
          const navEvents = usageRef.current.navEvents;
          const currentNavEvent = navEvents[navEvents.length - 1];
          const timestamp = Date.now();
          currentNavEvent.duration = timestamp - currentNavEvent.timestamp;
          usageRef.current.navEvents.push({
            type: 'progress',
            step: stepKey,
            timestamp,
            duration: 0
          });
          if (onChangeStep) {
            onChangeStep({
              direction: 'next',
              stepKey,
              StepComponent: steps[stepKey]
            });
          }
          if (transitionDuration) {
            setTimeout(() => {
              setStep(stepKey);
            }, transitionDuration);
          } else {
            setStep(stepKey);
          }
        },
        goBack() {
          if (step === initialStep) {
            return;
          }
          const path = pathRef.current;
          path.pop();
          const lastStep = path[path.length - 1];
          const navEvents = usageRef.current.navEvents;
          const currentNavEvent = navEvents[navEvents.length - 1];
          const timestamp = Date.now();
          currentNavEvent.duration = timestamp - currentNavEvent.timestamp;
          usageRef.current.navEvents.push({
            type: 'back',
            step: lastStep,
            timestamp,
            duration: 0
          });
          if (onChangeStep) {
            onChangeStep({
              direction: 'back',
              stepKey: lastStep,
              StepComponent: steps[lastStep]
            });
          }
          if (transitionDuration) {
            setTimeout(() => {
              setStep(lastStep);
            }, transitionDuration);
          } else {
            setStep(lastStep);
          }
        },
        getState: () => state,
        setState: _state => {
          setState(_state);
        },
        getPath: () => [...pathRef.current],
        getUsage: () => {
          const currentTime = Date.now();
          const navEvents = usageRef.current.navEvents;
          const firstNavEvent = navEvents[0];
          const lastNavEvent = navEvents[navEvents.length - 1];
          lastNavEvent.duration = currentTime - lastNavEvent.timestamp;
          return {
            timeSinceStart: currentTime - firstNavEvent.timestamp,
            navEvents
          };
        }
      }
    }, children);
  }
  function Step() {
    const {
      CurrentStep
    } = (0, _react.useContext)(context);
    return /*#__PURE__*/_react.default.createElement(CurrentStep, null);
  }
  function useWizard() {
    const {
      CurrentStep: _,
      ...rest
    } = (0, _react.useContext)(context);
    return rest;
  }
  return {
    context,
    Provider,
    Step,
    useWizard
  };
}