"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTitle = PageTitle;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function PageTitle() {
  const {
    getPath
  } = (0, _.useWizard)();
  const [currentStep] = getPath().reverse();
  if (currentStep === 'installElasticAgent') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h1", null, "Select your shipper"));
  }
  if (currentStep === 'importData') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "l"
    }, /*#__PURE__*/_react.default.createElement("h1", null, "Incoming logs"));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, "Collect and analyze my logs"));
}