"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NameLogs = NameLogs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _step_panel = require("../../../shared/step_panel");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function NameLogs() {
  const {
    goToStep,
    getState,
    setState
  } = (0, _.useWizard)();
  const wizardState = getState();
  const [datasetName, setDatasetName] = (0, _react.useState)(wizardState.datasetName);
  function onContinue() {
    setState({
      ...getState(),
      datasetName
    });
    goToStep('configureLogs');
  }
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: "Give your logs a name"
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Pick a name for your logs, this will become your dataset name.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Name",
    helpText: "Special characters and space are not allowed."
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: "Dataset name",
    value: datasetName,
    onChange: event => setDatasetName(event.target.value)
  })))), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: "/app/observability/overview"
    }, "Skip for now"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onContinue,
      isDisabled: !datasetName
    }, "Save and Continue")]
  }));
}