"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgent = InstallElasticAgent;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _step_panel = require("../../../shared/step_panel");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InstallElasticAgent() {
  const {
    goToStep,
    goBack,
    getState,
    setState
  } = (0, _.useWizard)();
  const wizardState = getState();
  const [elasticAgentPlatform, setElasticAgentPlatform] = (0, _react.useState)(wizardState.elasticAgentPlatform);
  const [alternativeShippers, setAlternativeShippers] = (0, _react.useState)(wizardState.alternativeShippers);
  function onContinue() {
    setState({
      ...getState(),
      elasticAgentPlatform,
      alternativeShippers
    });
    goToStep('importData');
  }
  function createAlternativeShipperToggle(type) {
    return () => {
      setAlternativeShippers({
        ...alternativeShippers,
        [type]: !alternativeShippers[type]
      });
    };
  }
  function onBack() {
    goBack();
  }
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: "Install the Elastic Agent"
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Select a platform and run the command to install, enroll, and start the Elastic Agent. Do this for each host. For other platforms, see our downloads page. Review host requirements and other installation options.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    legend: "Choose platform",
    options: [{
      id: 'linux-tar',
      label: 'Linux Tar'
    }, {
      id: 'macos',
      label: 'MacOs'
    }, {
      id: 'windows',
      label: 'Windows'
    }, {
      id: 'deb',
      label: 'DEB'
    }, {
      id: 'rpm',
      label: 'RPM'
    }],
    type: "single",
    idSelected: elasticAgentPlatform,
    onChange: id => setElasticAgentPlatform(id)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "html",
    isCopyable: true
  }, PLATFORM_COMMAND[elasticAgentPlatform]), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(LogsTypeSection, {
    title: "Or select alternative shippers",
    description: ""
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Filebeat",
    iconType: "document",
    onClick: createAlternativeShipperToggle('filebeat'),
    isSelected: alternativeShippers.filebeat
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "fluentbit",
    iconType: "package",
    onClick: createAlternativeShipperToggle('fluentbit'),
    isSelected: alternativeShippers.fluentbit
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Logstash",
    iconType: "logstashIf",
    onClick: createAlternativeShipperToggle('logstash'),
    isSelected: alternativeShippers.logstash
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Fluentd",
    iconType: "package",
    onClick: createAlternativeShipperToggle('fluentd'),
    isSelected: alternativeShippers.fluentd
  }))))), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "ghost",
      fill: true,
      onClick: onBack
    }, "Back"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onContinue
    }, "Continue")]
  }));
}
function LogsTypeSection({
  title,
  description,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), children);
}
function OptionCard({
  title,
  iconType,
  onClick,
  isSelected
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType,
      size: "l"
    }),
    title: title,
    titleSize: "xs",
    paddingSize: "m",
    style: {
      height: 56
    },
    onClick: onClick,
    hasBorder: true,
    display: isSelected ? 'primary' : undefined
  });
}
const PLATFORM_COMMAND = {
  'linux-tar': `curl -O https://elastic.co/agent-setup.sh && sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==`,
  macos: `curl -O https://elastic.co/agent-setup.sh && sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==`,
  windows: `curl -O https://elastic.co/agent-setup.sh && sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==`,
  deb: `curl -O https://elastic.co/agent-setup.sh && sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==`,
  rpm: `curl -O https://elastic.co/agent-setup.sh && sudo bash agent-setup.sh -- service.name=my-service --url=https://elasticsearch:8220 --enrollment-token=SRSc2ozWUItWXNuWE5oZzdERFU6anJtY0FIzhSRGlzeTJYcUF5UklfUQ==`
};