"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Inspect = Inspect;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _step_panel = require("../../../shared/step_panel");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Inspect() {
  const {
    goBack,
    getState,
    getPath,
    getUsage
  } = (0, _.useWizard)();
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: "Inspect wizard"
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "State")), /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(getState(), null, 4)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Path")), /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(getPath(), null, 4)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, "Usage")), /*#__PURE__*/_react.default.createElement("pre", null, JSON.stringify(getUsage(), null, 4))), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "ghost",
      fill: true,
      onClick: goBack
    }, "Back")]
  }));
}