"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportData = ImportData;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _ = require(".");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _step_panel = require("../../../shared/step_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ImportData() {
  const {
    goToStep,
    goBack
  } = (0, _.useWizard)();
  const {
    data
  } = (0, _use_fetcher.useFetcher)(callApi => {
    return callApi('GET /internal/observability_onboarding/get_status');
  }, []);
  function onContinue() {
    goToStep('inspect');
  }
  function onBack() {
    goBack();
  }
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: ""
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, "It might take a few minutes for the data to get to Elasticsearch. If you're not seeing any, try generating some to verify. If you're having trouble connecting, check out the troubleshooting guide.")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, "Listening for incoming logs"))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    titleSize: "xs",
    steps: [{
      title: 'Ping received',
      status: data === null || data === void 0 ? void 0 : data.status,
      children: null
    }, {
      title: 'File found',
      status: 'complete',
      children: null
    }, {
      title: 'Downloading Elastic Agent',
      status: 'loading',
      children: null
    }, {
      title: 'Starting Elastic Agent',
      status: 'incomplete',
      children: null
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "help"
  }, "Need some help?")))), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "ghost",
      fill: true,
      onClick: onBack
    }, "Back"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onContinue
    }, "Continue")]
  }));
}