"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HorizontalSteps = HorizontalSteps;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HorizontalSteps() {
  const {
    getPath
  } = (0, _.useWizard)();
  const [currentStep, ...previousSteps] = getPath().reverse();
  function getStatus(stepKey) {
    if (currentStep === stepKey) {
      return 'current';
    }
    if (previousSteps.includes(stepKey)) {
      return 'complete';
    }
    return 'incomplete';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: [{
      title: 'Name logs',
      status: getStatus('nameLogs'),
      onClick: () => {}
    }, {
      title: 'Configure logs',
      status: getStatus('configureLogs'),
      onClick: () => {}
    }, {
      title: 'Install shipper',
      status: getStatus('installElasticAgent'),
      onClick: () => {}
    }, {
      title: 'Import data',
      status: getStatus('importData'),
      onClick: () => {}
    }]
  });
}