"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigureLogs = ConfigureLogs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _step_panel = require("../../../shared/step_panel");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ConfigureLogs() {
  const {
    goToStep,
    goBack,
    getState,
    setState
  } = (0, _.useWizard)();
  const wizardState = getState();
  const [logsType, setLogsType] = (0, _react.useState)(wizardState.logsType);
  const [uploadType, setUploadType] = (0, _react.useState)(wizardState.uploadType);
  function onContinue() {
    if (logsType && uploadType) {
      setState({
        ...getState(),
        logsType,
        uploadType
      });
      goToStep('installElasticAgent');
    }
  }
  function createLogsTypeToggle(type) {
    return () => {
      if (type === logsType) {
        setLogsType(undefined);
      } else {
        setLogsType(type);
      }
    };
  }
  function createUploadToggle(type) {
    return () => {
      if (type === uploadType) {
        setUploadType(undefined);
      } else {
        setUploadType(type);
      }
    };
  }
  function onBack() {
    goBack();
  }
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: "Choose what logs to collect"
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(LogsTypeSection, {
    title: "System logs",
    description: "The quickest way to start using Elastic is to start uploading logs from your system."
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Stream system logs",
    iconType: "document",
    onClick: createLogsTypeToggle('system'),
    isSelected: logsType === 'system'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(LogsTypeSection, {
    title: "Custom logs",
    description: "Stream custom logs files from your data sink to Elastic."
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Stream sys logs",
    iconType: "package",
    onClick: createLogsTypeToggle('sys'),
    isSelected: logsType === 'sys'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Stream HTTP Endpoint logs",
    iconType: "package",
    onClick: createLogsTypeToggle('http-endpoint'),
    isSelected: logsType === 'http-endpoint'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(LogsTypeSection, {
    title: "Stream logs",
    description: "Lorem ipsum"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Stream log file",
    iconType: "document",
    onClick: createLogsTypeToggle('log-file'),
    isSelected: logsType === 'log-file'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Send it from my service",
    iconType: "document",
    onClick: createLogsTypeToggle('service'),
    isSelected: logsType === 'service'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(LogsTypeSection, {
    title: "Log files",
    description: "Upload your custom logs files to start analyzing it with Elastic."
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Upload log file",
    iconType: "document",
    onClick: createUploadToggle('log-file'),
    isSelected: uploadType === 'log-file'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: "Get an API key",
    iconType: "document",
    onClick: createUploadToggle('api-key'),
    isSelected: uploadType === 'api-key'
  }))))), /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "ghost",
      fill: true,
      onClick: onBack
    }, "Back"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      fill: true,
      onClick: onContinue,
      isDisabled: !(logsType && uploadType)
    }, "Continue")]
  }));
}
function LogsTypeSection({
  title,
  description,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), children);
}
function OptionCard({
  title,
  iconType,
  onClick,
  isSelected
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType,
      size: "l"
    }),
    title: title,
    titleSize: "xs",
    paddingSize: "m",
    style: {
      height: 56
    },
    onClick: onClick,
    hasBorder: true,
    display: isSelected ? 'primary' : undefined
  });
}