"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Home = Home;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _filmstrip_transition = require("../../shared/filmstrip_transition");
var _logs_onboarding_wizard = require("./logs_onboarding_wizard");
var _horizontal_steps = require("./logs_onboarding_wizard/horizontal_steps");
var _page_title = require("./logs_onboarding_wizard/page_title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Home({
  animated = true
}) {
  if (animated) {
    return /*#__PURE__*/_react.default.createElement(AnimatedTransitionsWizard, null);
  }
  return /*#__PURE__*/_react.default.createElement(StillTransitionsWizard, null);
}
function StillTransitionsWizard() {
  return /*#__PURE__*/_react.default.createElement(_logs_onboarding_wizard.Provider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_logs_onboarding_wizard.Step, null))));
}
const TRANSITION_DURATION = 180;
function AnimatedTransitionsWizard() {
  const [transition, setTransition] = (0, _react.useState)('ready');
  const TransitionComponent = (0, _react.useRef)(() => null);
  function onChangeStep({
    direction,
    StepComponent
  }) {
    setTransition(direction);
    TransitionComponent.current = StepComponent;
    setTimeout(() => {
      setTransition('ready');
    }, TRANSITION_DURATION + 10);
  }
  return /*#__PURE__*/_react.default.createElement(_logs_onboarding_wizard.Provider, {
    transitionDuration: TRANSITION_DURATION,
    onChangeStep: onChangeStep
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(_horizontal_steps.HorizontalSteps, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      width: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(_filmstrip_transition.FilmstripTransition, {
    duration: TRANSITION_DURATION,
    transition: transition
  }, /*#__PURE__*/_react.default.createElement(_filmstrip_transition.FilmstripFrame, {
    position: "left"
  },
  // eslint-disable-next-line react/jsx-pascal-case
  transition === 'back' ? /*#__PURE__*/_react.default.createElement(TransitionComponent.current, null) : null), /*#__PURE__*/_react.default.createElement(_filmstrip_transition.FilmstripFrame, {
    position: "center"
  }, /*#__PURE__*/_react.default.createElement(_logs_onboarding_wizard.Step, null)), /*#__PURE__*/_react.default.createElement(_filmstrip_transition.FilmstripFrame, {
    position: "right"
  },
  // eslint-disable-next-line react/jsx-pascal-case
  transition === 'next' ? /*#__PURE__*/_react.default.createElement(TransitionComponent.current, null) : null)))));
}