"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingAppRoot = ObservabilityOnboardingAppRoot;
exports.renderApp = exports.onboardingRoutes = exports.onBoardingTitle = exports.observabilityOnboardingRouter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _public3 = require("@kbn/observability-plugin/public");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _home = require("../components/app/home");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const onBoardingTitle = _i18n.i18n.translate('xpack.observability_onboarding.breadcrumbs.onboarding', {
  defaultMessage: 'Onboarding'
});
exports.onBoardingTitle = onBoardingTitle;
const onboardingRoutes = [{
  exact: true,
  path: '/',
  render: () => /*#__PURE__*/_react2.default.createElement(_reactRouterDom.Redirect, {
    to: "/observabilityOnboarding"
  }),
  breadcrumb: onBoardingTitle
}];
exports.onboardingRoutes = onboardingRoutes;
function ObservabilityOnboardingApp() {
  const [darkMode] = (0, _public2.useUiSetting$)('theme:darkMode');
  const {
    http
  } = (0, _public2.useKibana)().services;
  const basePath = http.basePath.get();
  (0, _public3.useBreadcrumbs)([{
    text: onBoardingTitle,
    href: basePath + '/app/observabilityOnboarding'
  }, {
    text: _i18n.i18n.translate('xpack.observability_onboarding.breadcrumbs.logs', {
      defaultMessage: 'Logs'
    })
  }]);
  return /*#__PURE__*/_react2.default.createElement(_react.ThemeProvider, {
    theme: outerTheme => ({
      ...outerTheme,
      eui: darkMode ? _uiTheme.euiDarkVars : _uiTheme.euiLightVars,
      darkMode
    })
  }, /*#__PURE__*/_react2.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "csmMainContainer"
  }, /*#__PURE__*/_react2.default.createElement(_home.Home, null)));
}
const observabilityOnboardingRouter = (0, _typedReactRouterConfig.createRouter)({});
exports.observabilityOnboardingRouter = observabilityOnboardingRouter;
function ObservabilityOnboardingAppRoot({
  appMountParameters,
  core,
  deps,
  corePlugins: {
    observability,
    data
  }
}) {
  const {
    history
  } = appMountParameters;
  const i18nCore = core.i18n;
  const plugins = {
    ...deps
  };
  return /*#__PURE__*/_react2.default.createElement(_public2.RedirectAppLinks, {
    className: _public.APP_WRAPPER_CLASS,
    application: core.application
  }, /*#__PURE__*/_react2.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      observability,
      data
    }
  }, /*#__PURE__*/_react2.default.createElement(_public2.KibanaThemeProvider, {
    theme$: appMountParameters.theme$,
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    }
  }, /*#__PURE__*/_react2.default.createElement(i18nCore.Context, null, /*#__PURE__*/_react2.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: observabilityOnboardingRouter
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react2.default.createElement(ObservabilityOnboardingApp, null)))))));
}

/**
 * This module is rendered asynchronously in the Kibana platform.
 */

const renderApp = ({
  core,
  deps,
  appMountParameters,
  corePlugins
}) => {
  const {
    element
  } = appMountParameters;
  _reactDom.default.render( /*#__PURE__*/_react2.default.createElement(ObservabilityOnboardingAppRoot, {
    appMountParameters: appMountParameters,
    core: core,
    deps: deps,
    corePlugins: corePlugins
  }), element);
  return () => {
    corePlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;