"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsfeedPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var Rx = _interopRequireWildcard(require("rxjs"));
var _operators = require("rxjs/operators");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _newsfeed_header_nav_button = require("./components/newsfeed_header_nav_button");
var _api = require("./lib/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class NewsfeedPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "stop$", new Rx.ReplaySubject(1));
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    const config = initializerContext.config.get();
    this.config = Object.freeze({
      ...config,
      // We need wrap them in moment.duration because exposeToBrowser stringifies it.
      mainInterval: _moment.default.duration(config.mainInterval),
      fetchInterval: _moment.default.duration(config.fetchInterval)
    });
  }
  setup(core) {
    return {};
  }
  start(core, {
    screenshotMode
  }) {
    const isScreenshotMode = screenshotMode.isScreenshotMode();
    const api = this.createNewsfeedApi(this.config, _api.NewsfeedApiEndpoint.KIBANA, isScreenshotMode);
    core.chrome.navControls.registerRight({
      order: 1000,
      mount: target => this.mount(api, target, core.theme.theme$, core.customBranding.hasCustomBranding$)
    });
    return {
      createNewsFeed$: endpoint => {
        const config = Object.assign({}, this.config, {
          service: {
            ...this.config.service,
            pathTemplate: `/${endpoint}/v{VERSION}.json`
          }
        });
        const {
          fetchResults$
        } = this.createNewsfeedApi(config, endpoint, isScreenshotMode);
        return fetchResults$;
      }
    };
  }
  stop() {
    this.stop$.next();
  }
  createNewsfeedApi(config, newsfeedId, isScreenshotMode) {
    const api = (0, _api.getApi)(config, this.kibanaVersion, newsfeedId, isScreenshotMode);
    return {
      markAsRead: api.markAsRead,
      fetchResults$: api.fetchResults$.pipe((0, _operators.takeUntil)(this.stop$),
      // stop the interval when stop method is called
      (0, _operators.catchError)(() => Rx.of(null)) // do not throw error
      )
    };
  }

  mount(api, targetDomElement, theme$, hasCustomBranding$) {
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_newsfeed_header_nav_button.NewsfeedNavButton, {
      newsfeedApi: api,
      hasCustomBranding$: hasCustomBranding$
    }))), targetDomElement);
    return () => _reactDom.default.unmountComponentAtNode(targetDomElement);
  }
}
exports.NewsfeedPublicPlugin = NewsfeedPublicPlugin;