"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NeverFetchNewsfeedApiDriver = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * NewsfeedApiDriver variant that never fetches results. This is useful for instances where Kibana is started
 * without any user interaction like when generating a PDF or PNG report.
 */
class NeverFetchNewsfeedApiDriver {
  shouldFetch() {
    return false;
  }
  fetchNewsfeedItems() {
    throw new Error('Not implemented!');
  }
}
exports.NeverFetchNewsfeedApiDriver = NeverFetchNewsfeedApiDriver;