"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _top_nav_menu = require("./top_nav_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class NavigationPublicPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "topNavMenuExtensionsRegistry", new _top_nav_menu.TopNavMenuExtensionsRegistry());
  }
  setup(core) {
    return {
      registerMenuItem: this.topNavMenuExtensionsRegistry.register.bind(this.topNavMenuExtensionsRegistry)
    };
  }
  start(core, {
    unifiedSearch
  }) {
    const extensions = this.topNavMenuExtensionsRegistry.getAll();
    return {
      ui: {
        TopNavMenu: (0, _top_nav_menu.createTopNav)(unifiedSearch, extensions),
        AggregateQueryTopNavMenu: (0, _top_nav_menu.createTopNav)(unifiedSearch, extensions)
      }
    };
  }
  stop() {}
}
exports.NavigationPublicPlugin = NavigationPublicPlugin;