"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultStatusIndicator = void 0;
exports.SummaryStatus = SummaryStatus;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _status_icon = require("../status_icon");
var _status = require("../../alerts/status");
require("./summary_status.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const wrapChild = ({
  label,
  value,
  ...props
}, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, (0, _extends2.default)({
  style: {
    maxWidth: 200
  },
  key: `summary-status-item-${index}`,
  grow: false
}, props), /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
  title: value,
  className: "monSummaryStatusNoWrap__stat",
  titleSize: "xxxs",
  textAlign: "left",
  description: label ? `${label}` : ''
}));
const DefaultIconComponent = ({
  status
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.monitoring.summaryStatus.statusIconTitle",
  defaultMessage: "Status: {statusIcon}",
  values: {
    statusIcon: /*#__PURE__*/_react.default.createElement(_status_icon.StatusIcon, {
      type: status.toUpperCase(),
      label: _i18n.i18n.translate('xpack.monitoring.summaryStatus.statusIconLabel', {
        defaultMessage: 'Status: {status}',
        values: {
          status
        }
      })
    })
  }
}));
const DefaultStatusIndicator = ({
  status,
  IconComponent,
  isOnline = false
}) => {
  if (!(status !== null && status !== void 0 && status.length)) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    "data-test-subj": "status",
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(IconComponent, {
      status: status,
      isOnline: isOnline
    }), "\xA0", (0, _lodash.capitalize)(status)),
    titleSize: "xxxs",
    textAlign: "left",
    className: "monSummaryStatusNoWrap__stat",
    description: _i18n.i18n.translate('xpack.monitoring.summaryStatus.statusDescription', {
      defaultMessage: 'Status'
    })
  });
};
exports.DefaultStatusIndicator = DefaultStatusIndicator;
function SummaryStatus({
  metrics,
  alerts,
  status,
  isOnline = false,
  IconComponent = DefaultIconComponent,
  StatusIndicator = DefaultStatusIndicator,
  ...props
}) {
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, props, {
    className: "monSummaryStatusNoWrap"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate",
    style: {
      maxWidth: 200
    },
    key: `summary-status-item-status`,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(StatusIndicator, {
    status: status,
    isOnline: isOnline,
    IconComponent: IconComponent
  })), alerts ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
      showOnlyCount: true,
      alerts: alerts
    }),
    titleSize: "xxxs",
    textAlign: "left",
    className: "monSummaryStatusNoWrap__stat",
    description: _i18n.i18n.translate('xpack.monitoring.summaryStatus.alertsDescription', {
      defaultMessage: 'Alerts'
    })
  })) : null, metrics.map(wrapChild)));
}