"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetupModeToggleButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-plugin/public");
var _constants = require("../../../common/constants");
var _exit_button = require("./exit_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SetupModeToggleButton = props => {
  const [isLoading, setIsLoading] = _react.default.useState(false);
  const trackStat = (0, _public.useUiTracker)({
    app: 'stack_monitoring'
  });
  function toggleSetupMode(enabled, stat) {
    setIsLoading(true);
    props.toggleSetupMode(enabled);
    trackStat({
      metric: `${_constants.TELEMETRY_METRIC_BUTTON_CLICK}setupmode_${stat}`,
      metricType: _public.METRIC_TYPE.CLICK
    });
    setIsLoading(false);
  }
  if (props.enabled) {
    return /*#__PURE__*/_react.default.createElement(_exit_button.SetupModeExitButton, {
      exitSetupMode: () => toggleSetupMode(false, 'exit')
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => toggleSetupMode(true, 'enter'),
    iconType: "flag",
    size: "s",
    iconSide: "right",
    isLoading: isLoading,
    "data-test-subj": "monitoringSetupModeBtn"
  }, _i18n.i18n.translate('xpack.monitoring.setupMode.enter', {
    defaultMessage: 'Enter setup mode'
  }));
};
exports.SetupModeToggleButton = SetupModeToggleButton;