"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReasonFound = ReasonFound;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _explanations = require("../explanations");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExplainWhyNoData = props => {
  const {
    reason
  } = props;
  const {
    property,
    data,
    context
  } = reason;
  switch (property) {
    case 'xpack.monitoring.collection.enabled':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainCollectionEnabled, props);
    case 'xpack.monitoring.collection.interval':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainCollectionInterval, props);
    case 'xpack.monitoring.exporters':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainExporters, props);
    case 'xpack.monitoring.exporters.cloud_enabled':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainExportersCloud, null);
    case 'xpack.monitoring.enabled':
      return /*#__PURE__*/_react.default.createElement(_explanations.ExplainPluginEnabled, props);
    case 'custom':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, reason.message));
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.noData.reasons.explainWhyNoDataDescription",
        defaultMessage: "There is a {context} setting that has {property} set to {data}.",
        values: {
          context: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, context),
          property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
          data: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, data)
        }
      })));
  }
};
function ReasonFound(props) {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(ExplainWhyNoData, props));
}
ReasonFound.propTypes = {
  enabler: _propTypes.default.object.isRequired,
  reason: _propTypes.default.object.isRequired
};