"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplainExporters = ExplainExporters;
exports.ExplainExportersCloud = ExplainExportersCloud;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _blurbs = require("../../blurbs");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExplainExporters({
  reason
}) {
  const {
    context,
    property,
    data
  } = reason;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_blurbs.ChangesNeeded, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "half"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textLeft"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exportersDescription",
    defaultMessage: "We checked the {context} settings for {property}, and found the reason: {data}.",
    values: {
      context: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, context),
      property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
      data: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, data)
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exporters.problemWithConfigDescription",
    defaultMessage: "Using monitoring exporters to ship the monitoring data to a remote monitoring cluster is highly recommended as it keeps the integrity of the monitoring data safe no matter what the state of the production cluster. However, as this instance of Kibana could not find any monitoring data, there seems to be a problem with the {property} configuration, or the {monitoringEs} settings in {kibanaConfig}.",
    values: {
      property: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, property),
      monitoringEs: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.monitoring.elasticsearch"),
      kibanaConfig: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kibana.yml")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exporters.checkConfigDescription",
    defaultMessage: "Check that the intended exporters are enabled for sending statistics to the monitoring cluster, and that the monitoring cluster host matches the {monitoringEs} setting in {kibanaConfig} to see monitoring data in this instance of Kibana.",
    values: {
      monitoringEs: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.monitoring.elasticsearch"),
      kibanaConfig: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kibana.yml")
    }
  }))));
}
ExplainExporters.propTypes = {
  reason: _propTypes.default.object.isRequired
};
function ExplainExportersCloud() {
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_blurbs.CloudDeployment, null), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    size: "half"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textLeft"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.noData.explanations.exportersCloudDescription",
    defaultMessage: "In Elastic Cloud, your monitoring data is stored in your dedicated monitoring cluster."
  }))));
}