"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineViewer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _detail_drawer = require("./detail_drawer");
var _queue = require("./queue");
var _statement_section = require("./statement_section");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PipelineViewer extends _react.default.Component {
  constructor() {
    super();
    (0, _defineProperty2.default)(this, "renderDetailDrawer", () => {
      if (!this.props.detailVertex) {
        return null;
      }
      return /*#__PURE__*/_react.default.createElement(_detail_drawer.DetailDrawer, {
        vertex: this.props.detailVertex,
        onHide: () => this.props.setDetailVertexId(undefined),
        timeseriesTooltipXValueFormatter: this.props.timeseriesTooltipXValueFormatter
      });
    });
    this.state = {
      detailDrawer: {
        vertex: null
      }
    };
  }
  render() {
    const {
      inputs,
      filters,
      outputs,
      queue
    } = this.props.pipeline;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logstash.pipeline_viewer.heading",
      defaultMessage: "Logstash pipelines"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      className: "monPipelineViewer"
    }, /*#__PURE__*/_react.default.createElement(_statement_section.StatementSection, {
      iconType: "logstashInput",
      headingText: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineViewer.inputsTitle', {
        defaultMessage: 'Inputs'
      }),
      elements: inputs,
      onShowVertexDetails: this.props.setDetailVertexId
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_queue.Queue, {
      queue: queue
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_statement_section.StatementSection, {
      iconType: "logstashFilter",
      headingText: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineViewer.filtersTitle', {
        defaultMessage: 'Filters'
      }),
      elements: filters,
      onShowVertexDetails: this.props.setDetailVertexId
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_statement_section.StatementSection, {
      iconType: "logstashOutput",
      headingText: _i18n.i18n.translate('xpack.monitoring.logstash.pipelineViewer.outputsTitle', {
        defaultMessage: 'Outputs'
      }),
      elements: outputs,
      onShowVertexDetails: this.props.setDetailVertexId
    }), this.renderDetailDrawer())));
  }
}
exports.PipelineViewer = PipelineViewer;
PipelineViewer.propTypes = {
  pipeline: _propTypes.default.shape({
    inputs: _propTypes.default.array.isRequired,
    filters: _propTypes.default.array.isRequired,
    outputs: _propTypes.default.array.isRequired,
    queue: _propTypes.default.object.isRequired
  }).isRequired
};