"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailDrawer = DetailDrawer;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _sparkline = require("../../../sparkline");
var _format_number = require("../../../../lib/format_number");
var _i18nReact = require("@kbn/i18n-react");
require("./detail_drawer.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderIcon(vertex) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: vertex.iconType,
    className: "lspvDetailDrawerIcon"
  });
}
function renderPluginBasicStats(vertex, timeseriesTooltipXValueFormatter) {
  const eventsLatencyValueFormatter = value => (0, _format_number.formatMetric)(value, '0.[00]a', 'ms/e');
  const latestEventsLatency = Array.isArray(vertex.stats.millis_per_event.data) && vertex.stats.millis_per_event.data.length > 0 ? (0, _lodash.last)(vertex.stats.millis_per_event.data)[1] : null;
  const eventsLatencyRow = vertex.pluginType === 'input' ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_latency"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsLatencyLabel",
    defaultMessage: "Events Latency"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "lspvDetailDrawerSparklineContainer"
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.stats.millis_per_event.data,
    options: {
      xaxis: vertex.stats.millis_per_event.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsLatencyValueFormatter
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, eventsLatencyValueFormatter(latestEventsLatency)));
  const eventsOutRateValueFormatter = value => (0, _format_number.formatMetric)(value, '0.[0]a', 'e/s');
  const eventsOutRateRow = /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_out_rate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsEmittedRateLabel",
    defaultMessage: "Events Emitted Rate"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "lspvDetailDrawerSparklineContainer"
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.eventsPerSecond.data,
    options: {
      xaxis: vertex.eventsPerSecond.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsOutRateValueFormatter
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, eventsOutRateValueFormatter(vertex.latestEventsPerSecond)));
  const eventsInValueFormatter = value => (0, _format_number.formatMetric)(value, '0a', 'events');
  const latestEventsIn = Array.isArray(vertex.stats.events_in.data) && vertex.stats.events_in.data.length > 0 ? (0, _lodash.last)(vertex.stats.events_in.data)[1] : null;
  const eventsInRow = vertex.pluginType === 'input' ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_in"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsReceivedLabel",
    defaultMessage: "Events Received"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "lspvDetailDrawerSparklineContainer"
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.stats.events_in.data,
    options: {
      xaxis: vertex.stats.events_in.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsInValueFormatter
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, eventsInValueFormatter(latestEventsIn)));
  const eventsOutValueFormatter = eventsInValueFormatter;
  const latestEventsOut = Array.isArray(vertex.stats.events_out.data) && vertex.stats.events_out.data.length > 0 ? (0, _lodash.last)(vertex.stats.events_out.data)[1] : null;
  const eventsOutRow = /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: "events_out"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.eventsEmittedLabel",
    defaultMessage: "Events Emitted"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "lspvDetailDrawerSparklineContainer"
  }, /*#__PURE__*/_react.default.createElement(_sparkline.Sparkline, {
    series: vertex.stats.events_out.data,
    options: {
      xaxis: vertex.stats.events_out.timeRange
    },
    tooltip: {
      enabled: true,
      xValueFormatter: timeseriesTooltipXValueFormatter,
      yValueFormatter: eventsOutValueFormatter
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, eventsOutValueFormatter(latestEventsOut)));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, null, eventsLatencyRow, eventsOutRateRow, eventsInRow, eventsOutRow));
}
function renderIfBasicStats() {
  return /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.noMetricsForIfDescription",
    defaultMessage: "There are currently no metrics to show for this if condition."
  }));
}
function renderQueueBasicStats() {
  return /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.noMetricsForQueueDescription",
    defaultMessage: "There are currently no metrics to show for the queue."
  }));
}
function renderBasicStats(vertex, timeseriesTooltipXValueFormatter) {
  switch (vertex.typeString) {
    case 'plugin':
      return renderPluginBasicStats(vertex, timeseriesTooltipXValueFormatter);
      break;
    case 'if':
      return renderIfBasicStats(vertex, timeseriesTooltipXValueFormatter);
      break;
    case 'queue':
      return renderQueueBasicStats(vertex, timeseriesTooltipXValueFormatter);
      break;
  }
}
function renderPluginBasicInfo(vertex) {
  if (vertex.hasExplicitId) {
    return /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logstash.pipeline.detailDrawer.vertexIdDescription",
      defaultMessage: "This {vertexType}'s ID is {vertexId}.",
      values: {
        vertexType: vertex.typeString,
        vertexId: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, vertex.id)
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.specifyVertexIdDescription",
    defaultMessage: "This {vertexType} does not have an ID explicitly specified. Specifying an ID allows you to track differences across pipeline changes. You can explicitly specify an ID for this plugin like so:",
    values: {
      vertexType: vertex.typeString
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, vertex.name, ' ', `{
  id => "mySpecialId"
}`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
}
function renderIfBasicInfo(vertex) {
  const ifCode = `if (${vertex.subtitle}) {
  ...
}`;
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.conditionalStatementDescription",
    defaultMessage: "This is a conditional statement in your pipeline."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, ifCode), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
}
function renderQueueBasicInfo() {
  return /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.logstash.pipeline.detailDrawer.structureDescription",
    defaultMessage: "This is an internal structure used by Logstash to buffer events between inputs and the rest of the pipeline."
  }));
}
function renderBasicInfo(vertex) {
  switch (vertex.typeString) {
    case 'plugin':
      return renderPluginBasicInfo(vertex);
      break;
    case 'if':
      return renderIfBasicInfo(vertex);
      break;
    case 'queue':
      return renderQueueBasicInfo(vertex);
      break;
  }
}
function renderTitle(vertex) {
  switch (vertex.typeString) {
    case 'plugin':
      return `${vertex.title} ${vertex.pluginType}`;
      break;
    case 'if':
    case 'queue':
      return vertex.title;
      break;
  }
}
function DetailDrawer({
  vertex,
  onHide,
  timeseriesTooltipXValueFormatter
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "s",
    onClose: onHide
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "baseline",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, renderIcon(vertex)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, renderTitle(vertex)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, renderBasicInfo(vertex), renderBasicStats(vertex, timeseriesTooltipXValueFormatter))));
}