"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Statement = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Statement {
  constructor(vertex) {
    const {
      id,
      hasExplicitId,
      stats,
      meta
    } = vertex;
    this.id = id;
    this.hasExplicitId = hasExplicitId;
    this.stats = stats;
    this.meta = meta;

    // storing a direct reference to the source vertex is convenient
    // for interoperability with components that use the existing graph
    this.vertex = vertex;
  }
}
exports.Statement = Statement;