"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginStatement = void 0;
var _statement = require("./statement");
var _plugin_element = require("../list/plugin_element");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class PluginStatement extends _statement.Statement {
  constructor(vertex) {
    super(vertex);
    const {
      pluginType,
      name
    } = vertex;
    this.pluginType = pluginType; // input, filter, or output
    this.name = name; // twitter, grok, elasticsearch, etc.
  }

  toList(depth, parentId) {
    return [new _plugin_element.PluginElement(this, depth, parentId)];
  }
  static fromPipelineGraphVertex(pluginVertex) {
    return new PluginStatement(pluginVertex);
  }
}
exports.PluginStatement = PluginStatement;