"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Logs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _legacy_shims = require("../../legacy_shims");
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var _formatting = require("../../../common/formatting");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reason = require("./reason");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormattedDateTimeLocal = timestamp => {
  var _Legacy$shims$uiSetti;
  const timezone = (_Legacy$shims$uiSetti = _legacy_shims.Legacy.shims.uiSettings) === null || _Legacy$shims$uiSetti === void 0 ? void 0 : _Legacy$shims$uiSetti.get('dateFormat:tz');
  return (0, _formatting.formatDateTimeLocal)(timestamp, timezone);
};
const columnTimestampTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.timestampTitle', {
  defaultMessage: 'Timestamp'
});
const columnLevelTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.levelTitle', {
  defaultMessage: 'Level'
});
const columnTypeTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.typeTitle', {
  defaultMessage: 'Type'
});
const columnMessageTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.messageTitle', {
  defaultMessage: 'Message'
});
const columnComponentTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.componentTitle', {
  defaultMessage: 'Component'
});
const columnNodeTitle = _i18n.i18n.translate('xpack.monitoring.logs.listing.nodeTitle', {
  defaultMessage: 'Node'
});
const columns = [{
  field: 'timestamp',
  name: columnTimestampTitle,
  width: '12%',
  render: timestamp => getFormattedDateTimeLocal(timestamp)
}, {
  field: 'level',
  name: columnLevelTitle,
  width: '5%'
}, {
  field: 'type',
  name: columnTypeTitle,
  width: '10%',
  render: type => (0, _lodash.upperFirst)(type)
}, {
  field: 'message',
  name: columnMessageTitle,
  width: '55%'
}, {
  field: 'component',
  name: columnComponentTitle,
  width: '18%'
}];
const clusterColumns = [{
  field: 'timestamp',
  name: columnTimestampTitle,
  width: '12%',
  render: timestamp => getFormattedDateTimeLocal(timestamp)
}, {
  field: 'level',
  name: columnLevelTitle,
  width: '5%'
}, {
  field: 'type',
  name: columnTypeTitle,
  width: '10%',
  render: type => (0, _lodash.upperFirst)(type)
}, {
  field: 'message',
  name: columnMessageTitle,
  width: '45%'
}, {
  field: 'component',
  name: columnComponentTitle,
  width: '15%'
}, {
  field: 'node',
  name: columnNodeTitle,
  width: '13%'
}];
function getLogsUiLink(clusterUuid, nodeId, indexUuid) {
  const base = `${_legacy_shims.Legacy.shims.getBasePath()}/app/logs/link-to/${_constants.INFRA_SOURCE_ID}/logs`;
  const params = [];
  if (clusterUuid) {
    params.push(`elasticsearch.cluster.uuid:${clusterUuid}`);
  }
  if (nodeId) {
    params.push(`elasticsearch.node.id:${nodeId}`);
  }
  if (indexUuid) {
    params.push(`elasticsearch.index.name:${indexUuid}`);
  }
  if (params.length === 0) {
    return base;
  }
  return `${base}?filter=${params.join(' and ')}`;
}
class Logs extends _react.PureComponent {
  renderLogs() {
    const {
      logs: {
        enabled,
        logs
      },
      nodeId,
      indexUuid
    } = this.props;
    if (!enabled) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      items: logs || [],
      columns: nodeId || indexUuid ? columns : clusterColumns
    });
  }
  renderNoLogs() {
    const {
      logs: {
        enabled,
        reason
      }
    } = this.props;
    if (enabled) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_reason.Reason, {
      reason: reason
    });
  }
  renderCallout() {
    const uiCapabilities = _legacy_shims.Legacy.shims.capabilities;
    const show = uiCapabilities.logs && uiCapabilities.logs.show;
    const {
      logs: {
        enabled
      },
      nodeId,
      clusterUuid,
      indexUuid
    } = this.props;
    if (!enabled || !show) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      size: "m",
      title: _i18n.i18n.translate('xpack.monitoring.logs.listing.calloutTitle', {
        defaultMessage: 'Want to see more log entries?'
      }),
      iconType: "logsApp"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.logs.listing.linkText",
      defaultMessage: "Visit {link} to dive deeper.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: getLogsUiLink(clusterUuid, nodeId, indexUuid)
        }, _i18n.i18n.translate('xpack.monitoring.logs.listing.calloutLinkText', {
          defaultMessage: 'Logs'
        }))
      }
    })));
  }
  render() {
    const {
      nodeId,
      indexUuid,
      logs: {
        limit
      }
    } = this.props;
    let description;
    if (nodeId) {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.nodePageDescription', {
        defaultMessage: 'Showing the most recent log entries for this node, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    } else if (indexUuid) {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.indexPageDescription', {
        defaultMessage: 'Showing the most recent log entries for this index, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    } else {
      description = _i18n.i18n.translate('xpack.monitoring.logs.listing.clusterPageDescription', {
        defaultMessage: 'Showing the most recent log entries for this cluster, up to {limit} total log entries.',
        values: {
          limit
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.monitoring.logs.listing.pageTitle', {
      defaultMessage: 'Recent Log Entries'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.renderLogs(), this.renderNoLogs(), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.renderCallout());
  }
}
exports.Logs = Logs;