"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.License = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _legacy_shims = require("../../legacy_shims");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddLicense = ({
  uploadPath
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.updateLicenseTitle",
      defaultMessage: "Update your license"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.useAvailableLicenseDescription",
      defaultMessage: "If you already have a new license, upload it now."
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "updateLicenseButton",
      href: uploadPath
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.updateLicenseButtonLabel",
      defaultMessage: "Update license"
    }))
  });
};
class LicenseStatus extends _react.default.PureComponent {
  render() {
    const {
      isExpired,
      status,
      type,
      expiryDate
    } = this.props;
    const typeTitleCase = type.charAt(0).toUpperCase() + type.substr(1).toLowerCase();
    let icon;
    let title;
    let message;
    if (isExpired) {
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "danger",
        type: "warning"
      });
      message = /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.expiredLicenseStatusDescription",
        defaultMessage: "Your license expired on {expiryDate}",
        values: {
          expiryDate: /*#__PURE__*/_react.default.createElement("strong", null, expiryDate)
        }
      }));
      title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.expiredLicenseStatusTitle",
        defaultMessage: "Your {typeTitleCase} license has expired",
        values: {
          typeTitleCase
        }
      });
    } else {
      icon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "success",
        type: "checkInCircleFilled",
        size: "l"
      });
      message = expiryDate ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.activeLicenseStatusDescription",
        defaultMessage: "Your license will expire on {expiryDate}",
        values: {
          expiryDate: /*#__PURE__*/_react.default.createElement("strong", null, expiryDate)
        }
      })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.permanentActiveLicenseStatusDescription",
        defaultMessage: "Your license will never expire."
      }));
      title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.activeLicenseStatusTitle",
        defaultMessage: "Your {typeTitleCase} license is {status}",
        values: {
          typeTitleCase,
          status: status.toLowerCase()
        }
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h1", {
      "data-test-subj": "licenseText"
    }, title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "licenseSubText"
    }, message));
  }
}
const LicenseUpdateInfoForPrimary = ({
  isPrimaryCluster,
  uploadLicensePath
}) => {
  if (!isPrimaryCluster) {
    return null;
  }

  // viewed license is for the cluster directly connected to Kibana
  return /*#__PURE__*/_react.default.createElement(AddLicense, {
    uploadPath: uploadLicensePath
  });
};
const LicenseUpdateInfoForRemote = ({
  isPrimaryCluster
}) => {
  if (isPrimaryCluster) {
    return null;
  }

  // viewed license is for a remote monitored cluster not directly connected to Kibana
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.license.howToUpdateLicenseDescription",
    defaultMessage: "To update the license for this cluster, provide the license file through the Elasticsearch {apiText}:",
    values: {
      apiText: 'API'
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, null, `curl -XPUT -u <user> 'https://<host>:<port>/_license' -H 'Content-Type: application/json' -d @license.json`));
};
const License = props => {
  const {
    status,
    type,
    isExpired,
    expiryDate
  } = props;
  const licenseManagement = `${_legacy_shims.Legacy.shims.getBasePath()}/app/management/stack/license_management`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.license.heading",
    defaultMessage: "License"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(LicenseStatus, {
    isExpired: isExpired,
    status: status,
    type: type,
    expiryDate: expiryDate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(LicenseUpdateInfoForPrimary, props), /*#__PURE__*/_react.default.createElement(LicenseUpdateInfoForRemote, props))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, "For more license options please visit\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: licenseManagement
  }, "License Management"), "."))));
};
exports.License = License;