"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchIndices = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _formatting = require("../../../../common/formatting");
var _format_number = require("../../../lib/format_number");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _status_icon = require("../status_icon");
var _cluster_status = require("../cluster_status");
var _table = require("../../table");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _status = require("../../../alerts/status");
require("./indices.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getColumns = alerts => {
  return [{
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.nameTitle', {
      defaultMessage: 'Name'
    }),
    field: 'name',
    width: '350px',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "name"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/indices/${value}`),
      "data-test-subj": `indexLink-${value}`
    }, value))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.alertsColumnTitle', {
      defaultMessage: 'Alerts'
    }),
    field: 'alerts',
    sortable: true,
    render: (_field, index) => {
      return /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
        showBadge: true,
        alerts: alerts,
        stateFilter: state => state.meta.shardIndex === index.name
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.statusTitle', {
      defaultMessage: 'Status'
    }),
    field: 'status',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      className: "monElasticsearchIndicesTable__status",
      title: `Index status: ${value}`
    }, /*#__PURE__*/_react.default.createElement(_status_icon.ElasticsearchStatusIcon, {
      status: value
    }), "\xA0", (0, _lodash.capitalize)(value))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.documentCountTitle', {
      defaultMessage: 'Document Count'
    }),
    field: 'doc_count',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "documentCount"
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_ABBREVIATED))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.dataTitle', {
      defaultMessage: 'Data'
    }),
    field: 'data_size',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "dataSize"
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_BYTES))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.indexRateTitle', {
      defaultMessage: 'Index Rate'
    }),
    field: 'index_rate',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "indexRate"
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_FLOAT, '/s'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.searchRateTitle', {
      defaultMessage: 'Search Rate'
    }),
    field: 'search_rate',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "searchRate"
    }, (0, _format_number.formatMetric)(value, _formatting.LARGE_FLOAT, '/s'))
  }, {
    name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.unassignedShardsTitle', {
      defaultMessage: 'Unassigned Shards'
    }),
    field: 'unassigned_shards',
    sortable: true,
    render: value => /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "unassignedShards"
    }, (0, _format_number.formatMetric)(value, '0'))
  }];
};
const getNoDataMessage = () => {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indices.noIndicesMatchYourSelectionDescription",
    defaultMessage: "There are no indices that match your selections. Try changing the time range selection."
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indices.howToShowSystemIndicesDescription",
    defaultMessage: "If you are looking for system indices (e.g., .kibana), try checking \u2018Show system indices\u2019."
  })));
};
const ElasticsearchIndices = ({
  clusterStatus,
  indices,
  sorting,
  pagination,
  onTableChange,
  toggleShowSystemIndices,
  showSystemIndices,
  alerts
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.indices.heading",
    defaultMessage: "Elasticsearch indices"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_cluster_status.ClusterStatus, {
    stats: clusterStatus,
    alerts: alerts
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.elasticsearch.indices.systemIndicesLabel",
      defaultMessage: "Filter for system indices"
    }),
    checked: showSystemIndices,
    onChange: e => toggleShowSystemIndices(e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_table.EuiMonitoringTable, {
    className: "elasticsearchIndicesTable",
    rows: indices,
    columns: getColumns(alerts),
    sorting: sorting,
    pagination: pagination,
    message: getNoDataMessage(),
    search: {
      box: {
        incremental: true,
        placeholder: _i18n.i18n.translate('xpack.monitoring.elasticsearch.indices.monitoringTablePlaceholder', {
          defaultMessage: 'Filter Indices…'
        })
      }
    },
    onTableChange: onTableChange,
    executeQueryOptions: {
      defaultFields: ['name']
    }
  }))));
};
exports.ElasticsearchIndices = ElasticsearchIndices;