"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoTooltip = InfoTooltip;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
require("./info_tooltip.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InfoTooltip({
  series,
  bucketSize
}) {
  const tableRows = series.map((item, index) => {
    return /*#__PURE__*/_react.default.createElement("tr", {
      key: `chart-tooltip-${index}`,
      "data-debug-metric-agg": item.metric.metricAgg,
      "data-debug-metric-field": item.metric.field,
      "data-debug-metric-is-derivative": item.metric.isDerivative,
      "data-debug-metric-has-calculation": item.metric.hasCalculation
    }, /*#__PURE__*/_react.default.createElement("td", {
      className: "monChart__tooltipLabel"
    }, item.metric.label), /*#__PURE__*/_react.default.createElement("td", {
      className: "monChart__tooltipValue"
    }, item.metric.description));
  });
  return /*#__PURE__*/_react.default.createElement("table", null, /*#__PURE__*/_react.default.createElement("tbody", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("td", {
    className: "monChart__tooltipLabel"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.chart.infoTooltip.intervalLabel",
    defaultMessage: "Interval"
  })), /*#__PURE__*/_react.default.createElement("td", {
    className: "monChart__tooltipValue"
  }, bucketSize)), tableRows));
}