"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Expression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_derived_index_pattern = require("../components/param_details_form/use_derived_index_pattern");
var _kuery = require("../../lib/kuery");
var _kuery_bar = require("../../components/kuery_bar");
var _alert_param_duration = require("../flyout_expressions/alert_param_duration");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_TYPING_DEBOUNCE_MS = 500;
const Expression = ({
  ruleParams,
  config,
  setRuleParams,
  dataViews,
  errors,
  defaults,
  expressionConfig
}) => {
  var _ruleParams$duration;
  const {
    derivedIndexPattern
  } = (0, _use_derived_index_pattern.useDerivedIndexPattern)(dataViews, config);
  const onFilterChange = (0, _react.useCallback)(filter => {
    if (derivedIndexPattern) setRuleParams('filterQueryText', filter);
    if (derivedIndexPattern) setRuleParams('filterQuery', (0, _kuery.convertKueryToElasticSearchQuery)(filter, derivedIndexPattern) || '');
  }, [setRuleParams, derivedIndexPattern]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, FILTER_TYPING_DEBOUNCE_MS), [onFilterChange]);
  const kueryBar = derivedIndexPattern ? /*#__PURE__*/_react.default.createElement(_kuery_bar.KueryBar, {
    value: ruleParams.filterQueryText,
    derivedIndexPattern: derivedIndexPattern,
    onSubmit: onFilterChange,
    onChange: debouncedOnFilterChange
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const duration = expressionConfig !== null && expressionConfig !== void 0 && expressionConfig.showDuration ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_alert_param_duration.AlertParamDuration, {
    key: "duration",
    name: 'duration',
    duration: (_ruleParams$duration = ruleParams.duration) !== null && _ruleParams$duration !== void 0 ? _ruleParams$duration : defaults === null || defaults === void 0 ? void 0 : defaults.duration,
    label: _i18n.i18n.translate('xpack.monitoring.alerts.legacy.paramDetails.duration.label', {
      defaultMessage: 'In the last'
    }),
    errors: errors.duration,
    setRuleParams: setRuleParams
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, duration, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.monitoring.alerts.filterLable', {
      defaultMessage: 'Filter'
    }),
    helpText: _i18n.i18n.translate('xpack.monitoring.alerts.filterHelpText', {
      defaultMessage: 'Use a KQL expression to limit the scope of your alert trigger.'
    })
  }, kueryBar), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};

// for lazy loading
// eslint-disable-next-line import/no-default-export
exports.Expression = Expression;
var _default = Expression;
exports.default = _default;