"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertParamDuration = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TIME_UNITS;
(function (TIME_UNITS) {
  TIME_UNITS["SECOND"] = "s";
  TIME_UNITS["MINUTE"] = "m";
  TIME_UNITS["HOUR"] = "h";
  TIME_UNITS["DAY"] = "d";
})(TIME_UNITS || (TIME_UNITS = {}));
function getTimeUnitLabel(timeUnit = TIME_UNITS.SECOND, timeValue = '0') {
  switch (timeUnit) {
    case TIME_UNITS.SECOND:
      return _i18n.i18n.translate('xpack.monitoring.alerts.flyoutExpressions.timeUnits.secondLabel', {
        defaultMessage: '{timeValue, plural, one {second} other {seconds}}',
        values: {
          timeValue
        }
      });
    case TIME_UNITS.MINUTE:
      return _i18n.i18n.translate('xpack.monitoring.alerts.flyoutExpressions.timeUnits.minuteLabel', {
        defaultMessage: '{timeValue, plural, one {minute} other {minutes}}',
        values: {
          timeValue
        }
      });
    case TIME_UNITS.HOUR:
      return _i18n.i18n.translate('xpack.monitoring.alerts.flyoutExpressions.timeUnits.hourLabel', {
        defaultMessage: '{timeValue, plural, one {hour} other {hours}}',
        values: {
          timeValue
        }
      });
    case TIME_UNITS.DAY:
      return _i18n.i18n.translate('xpack.monitoring.alerts.flyoutExpressions.timeUnits.dayLabel', {
        defaultMessage: '{timeValue, plural, one {day} other {days}}',
        values: {
          timeValue
        }
      });
  }
}

// TODO: WHY does this not work?
// import { getTimeUnitLabel, TIME_UNITS } from '../../../triggers_actions_ui/public';

const parseRegex = /(\d+)([smhd]{1})/;
const AlertParamDuration = props => {
  const {
    name,
    label,
    setRuleParams,
    errors
  } = props;
  const parsed = parseRegex.exec(props.duration);
  const defaultValue = parsed && parsed[1] ? parseInt(parsed[1], 10) : 1;
  const defaultUnit = parsed && parsed[2] ? parsed[2] : TIME_UNITS.MINUTE;
  const [value, setValue] = _react.default.useState(defaultValue);
  const [unit, setUnit] = _react.default.useState(defaultUnit);
  const timeUnits = Object.values(TIME_UNITS).map(timeUnit => ({
    value: timeUnit,
    text: getTimeUnitLabel(timeUnit)
  }));
  _react.default.useEffect(() => {
    setRuleParams(name, `${value}${unit}`);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [unit, value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    error: errors,
    isInvalid: (errors === null || errors === void 0 ? void 0 : errors.length) > 0
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    compressed: true,
    value: value,
    onChange: e => {
      let newValue = parseInt(e.target.value, 10);
      if (isNaN(newValue)) {
        newValue = 0;
      }
      setValue(newValue);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: unit,
    onChange: e => setUnit(e.target.value),
    options: timeUnits
  }))));
};
exports.AlertParamDuration = AlertParamDuration;