"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildDocumentation = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const declarationLabel = _i18n.i18n.translate('monaco.esql.autocomplete.declarationLabel', {
  defaultMessage: 'Declaration:'
});
const examplesLabel = _i18n.i18n.translate('monaco.esql.autocomplete.examplesLabel', {
  defaultMessage: 'Examples:'
});

/** @internal **/
const buildDocumentation = (declaration, examples) => `
---
\
***${declarationLabel}***
\
  - \`\`${declaration}\`\`
\
---
${examples ? `\
***${examplesLabel}***
\
${examples.map(i => `
  - \`\`${i}\`\`
`)}` : ''}`;
exports.buildDocumentation = buildDocumentation;