"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.orderingCommandsDefinitions = exports.nullsOrderingCommandsDefinitions = exports.nullsCommandsDefinition = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const orderingCommandsDefinitions = [{
  label: 'asc',
  insertText: 'asc',
  kind: 17,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.ascDoc', {
    defaultMessage: 'Ascending Order'
  }),
  sortText: 'D'
}, {
  label: 'desc',
  insertText: 'desc',
  kind: 17,
  detail: _i18n.i18n.translate('monaco.esql.autocomplete.descDoc', {
    defaultMessage: 'Descending Order'
  }),
  sortText: 'D'
}];
exports.orderingCommandsDefinitions = orderingCommandsDefinitions;
const nullsCommandsDefinition = {
  label: 'nulls',
  insertText: 'nulls',
  kind: 13,
  sortText: 'D'
};
exports.nullsCommandsDefinition = nullsCommandsDefinition;
const nullsOrderingCommandsDefinitions = [{
  label: 'first',
  insertText: 'first',
  kind: 13,
  sortText: 'D'
}, {
  label: 'last',
  insertText: 'last',
  kind: 13,
  sortText: 'D'
}];
exports.nullsOrderingCommandsDefinitions = nullsOrderingCommandsDefinitions;