"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.REALTIME_ISSUE_DETECTED = exports.ANOMALY_DETECTION_JOB_REALTIME_ISSUE = void 0;
exports.registerJobsMonitoringRuleType = registerJobsMonitoringRuleType;
var _i18n = require("@kbn/i18n");
var _alerts = require("../../../common/constants/alerts");
var _app = require("../../../common/constants/app");
var _license = require("../../../common/license");
var _alerting_schema = require("../../routes/schemas/alerting_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANOMALY_DETECTION_JOB_REALTIME_ISSUE = 'anomaly_detection_realtime_issue';
exports.ANOMALY_DETECTION_JOB_REALTIME_ISSUE = ANOMALY_DETECTION_JOB_REALTIME_ISSUE;
const REALTIME_ISSUE_DETECTED = {
  id: ANOMALY_DETECTION_JOB_REALTIME_ISSUE,
  name: _i18n.i18n.translate('xpack.ml.jobsHealthAlertingRule.actionGroupName', {
    defaultMessage: 'Issue detected'
  })
};
exports.REALTIME_ISSUE_DETECTED = REALTIME_ISSUE_DETECTED;
function registerJobsMonitoringRuleType({
  alerting,
  mlServicesProviders,
  logger
}) {
  alerting.registerType({
    id: _alerts.ML_ALERT_TYPES.AD_JOBS_HEALTH,
    name: _i18n.i18n.translate('xpack.ml.jobsHealthAlertingRule.name', {
      defaultMessage: 'Anomaly detection jobs health'
    }),
    actionGroups: [REALTIME_ISSUE_DETECTED],
    defaultActionGroupId: ANOMALY_DETECTION_JOB_REALTIME_ISSUE,
    validate: {
      params: _alerting_schema.anomalyDetectionJobsHealthRuleParams
    },
    actionVariables: {
      context: [{
        name: 'results',
        description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.alertContext.resultsDescription', {
          defaultMessage: 'Results of the rule execution'
        })
      }, {
        name: 'message',
        description: _i18n.i18n.translate('xpack.ml.alertTypes.jobsHealthAlertingRule.alertContext.messageDescription', {
          defaultMessage: 'Alert info message'
        })
      }]
    },
    producer: _app.PLUGIN_ID,
    minimumLicenseRequired: _license.MINIMUM_FULL_LICENSE,
    isExportable: true,
    doesSetRecoveryContext: true,
    async executor(options) {
      const {
        services,
        rule: {
          name
        }
      } = options;
      const fakeRequest = {};
      const {
        getTestsResults
      } = mlServicesProviders.jobsHealthServiceProvider(services.savedObjectsClient, fakeRequest, logger);
      const executionResult = await getTestsResults(options);
      const unhealthyTests = executionResult.filter(({
        isHealthy
      }) => !isHealthy);
      if (unhealthyTests.length > 0) {
        logger.debug(`"${name}" rule is scheduling actions for tests: ${unhealthyTests.map(v => v.name).join(', ')}`);
        unhealthyTests.forEach(({
          name: alertInstanceName,
          context
        }) => {
          const alertInstance = services.alertFactory.create(alertInstanceName);
          alertInstance.scheduleActions(ANOMALY_DETECTION_JOB_REALTIME_ISSUE, context);
        });
      }

      // Set context for recovered alerts
      const {
        getRecoveredAlerts
      } = services.alertFactory.done();
      for (const recoveredAlert of getRecoveredAlerts()) {
        const recoveredAlertId = recoveredAlert.getId();
        const testResult = executionResult.find(v => v.name === recoveredAlertId);
        if (testResult) {
          recoveredAlert.setContext(testResult.context);
        }
      }
      return {
        state: {}
      };
    }
  });
}