"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION = void 0;
exports.createVisToADJobAction = createVisToADJobAction;
var _i18n = require("@kbn/i18n");
var _job_from_dashboard = require("../application/jobs/new_job/job_from_dashboard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION = 'createMLADJobAction';
exports.CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION = CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION;
function createVisToADJobAction(getStartServices) {
  return {
    id: 'create-ml-ad-job-action',
    type: CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION,
    getIconType(context) {
      return 'machineLearningApp';
    },
    getDisplayName: () => _i18n.i18n.translate('xpack.ml.actions.createADJobFromLens', {
      defaultMessage: 'Create anomaly detection job'
    }),
    async execute({
      embeddable
    }) {
      if (!embeddable) {
        throw new Error('Not possible to execute an action without the embeddable context');
      }
      try {
        if ((0, _job_from_dashboard.isLensEmbeddable)(embeddable)) {
          const [{
            showLensVisToADJobFlyout
          }, [coreStart, {
            share,
            data,
            lens
          }]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/job_creation/lens'))), getStartServices()]);
          if (lens === undefined) {
            return;
          }
          await showLensVisToADJobFlyout(embeddable, coreStart, share, data, lens);
        } else if ((0, _job_from_dashboard.isMapEmbeddable)(embeddable)) {
          const [{
            showMapVisToADJobFlyout
          }, [coreStart, {
            share,
            data
          }]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../embeddables/job_creation/map'))), getStartServices()]);
          await showMapVisToADJobFlyout(embeddable, coreStart, share, data);
        }
      } catch (e) {
        return Promise.reject();
      }
    },
    async isCompatible(context) {
      var _coreStart$applicatio, _coreStart$applicatio2;
      const embeddableType = context.embeddable.type;
      if (embeddableType !== 'map') {
        if (embeddableType !== 'lens' || !context.embeddable.getSavedVis()) {
          return false;
        }
      }
      const [{
        getJobsItemsFromEmbeddable,
        isCompatibleVisualizationType
      }, [coreStart, {
        lens
      }]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('../application/jobs/new_job/job_from_lens'))), getStartServices()]);
      const {
        isCompatibleMapVisualization
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('../application/jobs/new_job/job_from_map')));
      if (!((_coreStart$applicatio = coreStart.application.capabilities.ml) !== null && _coreStart$applicatio !== void 0 && _coreStart$applicatio.canCreateJob) || !((_coreStart$applicatio2 = coreStart.application.capabilities.ml) !== null && _coreStart$applicatio2 !== void 0 && _coreStart$applicatio2.canStartStopDatafeed)) {
        return false;
      }
      try {
        if (embeddableType === 'lens' && lens) {
          const {
            chartInfo
          } = await getJobsItemsFromEmbeddable(context.embeddable, lens);
          return isCompatibleVisualizationType(chartInfo);
        } else if ((0, _job_from_dashboard.isMapEmbeddable)(context.embeddable)) {
          return isCompatibleMapVisualization(context.embeddable);
        }
        return true;
      } catch (error) {
        // eslint-disable-next-line no-console
        console.error('Error attempting to check for ML job compatibility', error);
        return false;
      }
    }
  };
}