"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "APPLY_INFLUENCER_FILTERS_ACTION", {
  enumerable: true,
  get: function () {
    return _apply_influencer_filters_action.APPLY_INFLUENCER_FILTERS_ACTION;
  }
});
Object.defineProperty(exports, "APPLY_TIME_RANGE_SELECTION_ACTION", {
  enumerable: true,
  get: function () {
    return _apply_time_range_action.APPLY_TIME_RANGE_SELECTION_ACTION;
  }
});
Object.defineProperty(exports, "CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION", {
  enumerable: true,
  get: function () {
    return _open_vis_in_ml_action.CREATE_LENS_VIS_TO_ML_AD_JOB_ACTION;
  }
});
Object.defineProperty(exports, "EDIT_SWIMLANE_PANEL_ACTION", {
  enumerable: true,
  get: function () {
    return _edit_swimlane_panel_action.EDIT_SWIMLANE_PANEL_ACTION;
  }
});
Object.defineProperty(exports, "OPEN_IN_ANOMALY_EXPLORER_ACTION", {
  enumerable: true,
  get: function () {
    return _open_in_anomaly_explorer_action.OPEN_IN_ANOMALY_EXPLORER_ACTION;
  }
});
Object.defineProperty(exports, "SWIM_LANE_SELECTION_TRIGGER", {
  enumerable: true,
  get: function () {
    return _triggers.SWIM_LANE_SELECTION_TRIGGER;
  }
});
exports.registerMlUiActions = registerMlUiActions;
var _public = require("@kbn/embeddable-plugin/public");
var _edit_swimlane_panel_action = require("./edit_swimlane_panel_action");
var _open_in_anomaly_explorer_action = require("./open_in_anomaly_explorer_action");
var _open_vis_in_ml_action = require("./open_vis_in_ml_action");
var _apply_influencer_filters_action = require("./apply_influencer_filters_action");
var _triggers = require("./triggers");
var _apply_time_range_action = require("./apply_time_range_action");
var _clear_selection_action = require("./clear_selection_action");
var _edit_anomaly_charts_panel_action = require("./edit_anomaly_charts_panel_action");
var _apply_entity_filters_action = require("./apply_entity_filters_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Register ML UI actions
 */
function registerMlUiActions(uiActions, core) {
  // Initialize actions
  const editSwimlanePanelAction = (0, _edit_swimlane_panel_action.createEditSwimlanePanelAction)(core.getStartServices);
  const openInExplorerAction = (0, _open_in_anomaly_explorer_action.createOpenInExplorerAction)(core.getStartServices);
  const applyInfluencerFiltersAction = (0, _apply_influencer_filters_action.createApplyInfluencerFiltersAction)(core.getStartServices);
  const applyEntityFieldFilterAction = (0, _apply_entity_filters_action.createApplyEntityFieldFiltersAction)(core.getStartServices);
  const applyTimeRangeSelectionAction = (0, _apply_time_range_action.createApplyTimeRangeSelectionAction)(core.getStartServices);
  const clearSelectionAction = (0, _clear_selection_action.createClearSelectionAction)(core.getStartServices);
  const editExplorerPanelAction = (0, _edit_anomaly_charts_panel_action.createEditAnomalyChartsPanelAction)(core.getStartServices);
  const visToAdJobAction = (0, _open_vis_in_ml_action.createVisToADJobAction)(core.getStartServices);

  // Register actions
  uiActions.registerAction(editSwimlanePanelAction);
  uiActions.registerAction(openInExplorerAction);
  uiActions.registerAction(applyInfluencerFiltersAction);
  uiActions.registerAction(applyEntityFieldFilterAction);
  uiActions.registerAction(applyTimeRangeSelectionAction);
  uiActions.registerAction(clearSelectionAction);
  uiActions.registerAction(editExplorerPanelAction);

  // Assign triggers
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, editSwimlanePanelAction.id);
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, editExplorerPanelAction.id);
  uiActions.attachAction(_public.CONTEXT_MENU_TRIGGER, openInExplorerAction.id);
  uiActions.registerTrigger(_triggers.swimLaneSelectionTrigger);
  uiActions.registerTrigger(_triggers.entityFieldSelectionTrigger);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, applyInfluencerFiltersAction);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, applyTimeRangeSelectionAction);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, openInExplorerAction);
  uiActions.addTriggerAction(_triggers.SWIM_LANE_SELECTION_TRIGGER, clearSelectionAction);
  uiActions.addTriggerAction(_triggers.EXPLORER_ENTITY_FIELD_SELECTION_TRIGGER, applyEntityFieldFilterAction);
  uiActions.addTriggerAction(_public.CONTEXT_MENU_TRIGGER, visToAdJobAction);
}