"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APPLY_INFLUENCER_FILTERS_ACTION = void 0;
exports.createApplyInfluencerFiltersAction = createApplyInfluencerFiltersAction;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/dashboard-plugin/public");
var _explorer_constants = require("../application/explorer/explorer_constants");
var _embeddables = require("../embeddables");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const APPLY_INFLUENCER_FILTERS_ACTION = 'applyInfluencerFiltersAction';
exports.APPLY_INFLUENCER_FILTERS_ACTION = APPLY_INFLUENCER_FILTERS_ACTION;
const supportedApps = [_public.DASHBOARD_APP_ID];
function createApplyInfluencerFiltersAction(getStartServices) {
  return {
    id: 'apply-to-current-view',
    type: APPLY_INFLUENCER_FILTERS_ACTION,
    getIconType(context) {
      return 'filter';
    },
    getDisplayName() {
      return _i18n.i18n.translate('xpack.ml.actions.applyInfluencersFiltersTitle', {
        defaultMessage: 'Filter for value'
      });
    },
    async execute({
      data
    }) {
      if (!data) {
        throw new Error('No swim lane selection data provided');
      }
      const [, pluginStart] = await getStartServices();
      const filterManager = pluginStart.data.query.filterManager;
      filterManager.addFilters(data.lanes.map(influencerValue => {
        return {
          $state: {
            store: _esQuery.FilterStateStore.APP_STATE
          },
          meta: {
            alias: _i18n.i18n.translate('xpack.ml.actions.influencerFilterAliasLabel', {
              defaultMessage: '{labelValue}',
              values: {
                labelValue: `${data.viewByFieldName}:${influencerValue}`
              }
            }),
            controlledBy: _constants.CONTROLLED_BY_SWIM_LANE_FILTER,
            disabled: false,
            key: data.viewByFieldName,
            negate: false,
            params: {
              query: influencerValue
            },
            type: 'phrase'
          },
          query: {
            match_phrase: {
              [data.viewByFieldName]: influencerValue
            }
          }
        };
      }));
    },
    async isCompatible({
      embeddable,
      data
    }) {
      const [{
        application
      }] = await getStartServices();
      const appId = await (0, _rxjs.firstValueFrom)(application.currentAppId$);

      // Only compatible with view by influencer swim lanes and single selection
      return embeddable.type === _embeddables.ANOMALY_SWIMLANE_EMBEDDABLE_TYPE && data !== undefined && data.type === _explorer_constants.SWIMLANE_TYPE.VIEW_BY && data.viewByFieldName !== _explorer_constants.VIEW_BY_JOB_LABEL && data.lanes.length === 1 && supportedApps.includes(appId);
    }
  };
}